import argparse
import pathlib
import shutil
import sys


parser = argparse.ArgumentParser()

parser.add_argument('--output-dir', '-o', type=pathlib.Path, required=True)
parser.add_argument('--force', '-f', action='store_true')
parser.add_argument('--train-dataset', type=pathlib.Path, default='dataset/train')
parser.add_argument('--test-dataset', type=pathlib.Path, default='dataset/test')


def msg(*k, **kw):
    kw['file'] = sys.stderr
    print(*k, **kw)


def run(output_dir, force, train_dataset, test_dataset):
    if output_dir.exists():
        if not force:
            raise Exception(f'directory {output_dir} exists. Use -f to overwrite it')
        else:
            msg(f'Removing existing directory {output_dir}')
            shutil.rmtree(output_dir)
    output_dir.mkdir()

    # Dataset directory
    msg('Creating dataset directory')
    dataset_dir = output_dir / 'dataset'
    dataset_dir.mkdir()
    shutil.copy(train_dataset, dataset_dir / 'train')
    shutil.copy(test_dataset, dataset_dir / 'test')

    # Configuration directory
    msg('Creating configuration directory')
    conf_dir = output_dir / 'conf'
    conf_dir.mkdir()

    with open(conf_dir / 'embedding_params.py', 'w') as f:
        print('# Fill ARGS with positional arguments for the embedding method used', file=f)
        print('ARGS = []', file=f)
        print('', file=f)
        print('# Fill KEYWORDS with keyword arguments for the embedding method used', file=f)
        print('KEYWORDS={}', file=f)


    with open(conf_dir / 'classifier_hyperparams.py', 'w') as f:
        print('# Fill ARGS with positional arguments for the Scikit Learn model used', file=f)
        print('ARGS = []', file=f)
        print('', file=f)
        print('# Fill KEYWORDS with keyword arguments for the Scikit Learn model used', file=f)
        print('KEYWORDS={}', file=f)

    with open(conf_dir / 'conf.py', 'w') as f:
        print('# Embedding method to be used', file=f)
        print('EMBEDDING_METHOD = \'replace me\'', file=f)
        print('')
        print('# Classification method to be used', file=f)
        print('CLASSIFICATION_METHOD = \'replace me\'', file=f)
        print('')


if __name__ == '__main__':
    args = parser.parse_args()
    run(**vars(args))
