Code for OoMMix
===============
This code implements the paper "Out-of-manifold Regularization in Contextual Embedding Space for Text Classification" under the reviewed in ACL-IJCNLP 2021.

## Download dataset
Xiang Zhang (The first author in the paper "Character-level Convolutional Networks for Text Classification") provides the official link for the text classification benchmark and we use it.
([Official link](https://drive.google.com/drive/folders/0Bz8a_Dbh9Qhbfll6bVpmNUtUcFdjYmF2SEpmZUZUcVNiMUw1TWN6RDV3a0JHT3kxLVhVR2M?usp=sharing))

Extract the tar.gz file for further execution.

## Install dependency
Our testing environment is as follows.
* NVIDIA Titan-Xp 12GB
* Ubuntu 18.04
* nvidia-driver==450.102.04
* CUDA==11.0

```bash
python -m venv venv
source venv/bin/activate
pip install -r requirements.txt
```

## Configurable setting
The following command train our regularization with Amazon Review dataset with 0.5K training data.
```
python main.py --data_dir dataset/amazon_review_polarity_csv --dataset amazon_review_polarity --num_train_data 500 --mix_strategy oommix
```

The following parameter could be used.
```
usage: main.py [-h] [--seed SEED] --data_dir DATA_DIR [--dataset {ag_news,yahoo_answer,amazon_review_polarity,dbpedia}] [--num_train_data NUM_TRAIN_DATA] [--data_augment {none,eda,backtranslate,ssmba}] [--max_length MAX_LENGTH]
               [--restore RESTORE] [--epoch EPOCH] [--batch_size BATCH_SIZE] [--lr LR] [--drop_prob DROP_PROB] [--mix_strategy {none,tmix,nonlinearmix,mixuptransformer,oommix}] [--m_layer M_LAYER] [--d_layer D_LAYER] [--alpha ALPHA]
               [--coeff_intr COEFF_INTR] [--eval_every EVAL_EVERY] [--patience PATIENCE] [--gpu GPU]

optional arguments:
  -h, --help            show this help message and exit
  --seed SEED
  --data_dir DATA_DIR
  --dataset {ag_news,yahoo_answer,amazon_review_polarity,dbpedia}
  --num_train_data NUM_TRAIN_DATA
                        Number of train dataset. Use first `num_train` row. -1 means whole dataset
  --data_augment {none,eda,backtranslate,ssmba}
  --max_length MAX_LENGTH
  --restore RESTORE
  --epoch EPOCH
  --batch_size BATCH_SIZE
  --lr LR
  --drop_prob DROP_PROB
  --mix_strategy {none,tmix,nonlinearmix,mixuptransformer,oommix}
  --m_layer M_LAYER
  --d_layer D_LAYER
  --alpha ALPHA
  --coeff_intr COEFF_INTR
  --eval_every EVAL_EVERY
  --patience PATIENCE
  --gpu GPU
```

