/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.meteor.util;

import edu.cmu.meteor.aligner.LookupTableStemmer;
import edu.cmu.meteor.aligner.PartialAlignment;
import edu.cmu.meteor.aligner.SnowballStemmerWrapper;
import edu.cmu.meteor.aligner.Stemmer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import org.tartarus.snowball.ext.danishStemmer;
import org.tartarus.snowball.ext.dutchStemmer;
import org.tartarus.snowball.ext.englishStemmer;
import org.tartarus.snowball.ext.finnishStemmer;
import org.tartarus.snowball.ext.frenchStemmer;
import org.tartarus.snowball.ext.germanStemmer;
import org.tartarus.snowball.ext.hungarianStemmer;
import org.tartarus.snowball.ext.italianStemmer;
import org.tartarus.snowball.ext.norwegianStemmer;
import org.tartarus.snowball.ext.portugueseStemmer;
import org.tartarus.snowball.ext.romanianStemmer;
import org.tartarus.snowball.ext.russianStemmer;
import org.tartarus.snowball.ext.spanishStemmer;
import org.tartarus.snowball.ext.swedishStemmer;
import org.tartarus.snowball.ext.turkishStemmer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constants {
    public static final String VERSION = "1.5";
    public static final DecimalFormat minFormat = new DecimalFormat("#.##########");
    public static final URL DEFAULT_NBP_DIR_URL = ClassLoader.getSystemResource("nonbreaking");
    public static final int NBP_NUM_ONLY = 2;
    public static final int NBP_ANY = 1;
    public static final int MODULE_EXACT = 0;
    public static final int MODULE_STEM = 1;
    public static final int MODULE_SYNONYM = 2;
    public static final int MODULE_PARAPHRASE = 3;
    public static final int MAX_MODULES = 4;
    public static final double DEFAULT_WEIGHT_EXACT = 1.0;
    public static final double DEFAULT_WEIGHT_STEM = 1.0;
    public static final double DEFAULT_WEIGHT_SYNONYM = 1.0;
    public static final double DEFAULT_WEIGHT_PARAPHRASE = 1.0;
    public static final int DEFAULT_BEAM_SIZE = 40;
    public static final URL DEFAULT_STEM_DIR_URL = ClassLoader.getSystemResource("stem");
    public static final URL DEFAULT_SYN_DIR_URL = ClassLoader.getSystemResource("synonym");
    public static final URL DEFAULT_WORD_DIR_URL = ClassLoader.getSystemResource("function");
    public static final int LANG_EN = 0;
    public static final int LANG_CZ = 1;
    public static final int LANG_FR = 2;
    public static final int LANG_ES = 3;
    public static final int LANG_DE = 4;
    public static final int LANG_AR_BW_RED = 5;
    public static final int LANG_PT = 6;
    public static final int LANG_RU = 7;
    public static final int LANG_DA = 8;
    public static final int LANG_RO = 9;
    public static final int LANG_HU = 10;
    public static final int LANG_TR = 11;
    public static final int LANG_FI = 12;
    public static final int LANG_NL = 13;
    public static final int LANG_IT = 14;
    public static final int LANG_NO = 15;
    public static final int LANG_SE = 16;
    public static final int LANG_MAX = 16;
    public static final int LANG_OTHER = 99;
    private static HashSet<Integer> supportedLangIDs = null;
    public static final int TASK_ADQ = 0;
    public static final double[][] PARAM_ADQ = new double[][]{{0.75, 1.4, 0.45, 0.7}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    public static final double[][] WEIGHT_ADQ = new double[][]{{1.0, 1.0, 0.6, 0.8}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    public static final int TASK_RANK = 1;
    public static final double[][] PARAM_RANK = new double[][]{{0.85, 0.2, 0.6, 0.75}, {0.95, 0.2, 0.6, 0.8}, {0.9, 1.4, 0.6, 0.65}, {0.65, 1.3, 0.5, 0.8}, {0.95, 1.0, 0.55, 0.55}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.75, 1.4, 0.7, 0.5}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    public static final double[][] WEIGHT_RANK = new double[][]{{1.0, 0.6, 0.8, 0.6}, {1.0, 0.4, 0.0, 0.0}, {1.0, 0.2, 0.4, 0.0}, {1.0, 0.8, 0.6, 0.0}, {1.0, 0.8, 0.2, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {1.0, 0.5, 0.5, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    public static final int TASK_HTER = 2;
    public static final double[][] PARAM_HTER = new double[][]{{0.4, 1.5, 0.35, 0.55}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    public static final double[][] WEIGHT_HTER = new double[][]{{1.0, 0.2, 0.6, 0.8}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    public static final int TASK_UTIL = 3;
    public static final double[][] PARAM_UTIL = new double[][]{{0.65, 0.1, 0.55, 0.65}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    public static final double[][] WEIGHT_UTIL = new double[][]{{1.0, 0.0, 0.0, 0.8}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
    public static final int TASK_DEFAULT = 1;
    public static final int TASK_LI = 99;
    public static final double[] PARAM_I = new double[]{0.75, 1.4, 0.7, 0.5};
    public static final double[] WEIGHT_I = new double[]{1.0, 0.5, 0.5, 0.5};
    public static final int TASK_TUNE = 100;
    public static final double[] PARAM_TUNE = new double[]{0.5, 1.0, 0.5, 0.5};
    public static final double[] WEIGHT_TUNE = new double[]{1.0, 0.5, 0.5, 0.5};
    public static final int TASK_UNIVERSAL = 101;
    public static final double[] PARAM_U = new double[]{0.7, 1.4, 0.3, 0.7};
    public static final double[] WEIGHT_U = new double[]{1.0, 0.6, 0.0, 0.0};
    public static final int TASK_CUSTOM = -1;
    public static final int NO_NORMALIZE = 0;
    public static final int NORMALIZE_LC_ONLY = 1;
    public static final int NORMALIZE_KEEP_PUNCT = 2;
    public static final int NORMALIZE_NO_PUNCT = 3;
    public static Comparator<PartialAlignment> PARTIAL_COMPARE_TOTAL = new Comparator<PartialAlignment>(){

        @Override
        public int compare(PartialAlignment partialAlignment, PartialAlignment partialAlignment2) {
            int n = partialAlignment2.matches1 + partialAlignment2.matches2 - (partialAlignment.matches1 + partialAlignment.matches2);
            if (n > 0) {
                return 1;
            }
            if (n < 0) {
                return -1;
            }
            int n2 = partialAlignment.chunks - partialAlignment2.chunks;
            if (n2 != 0) {
                return n2;
            }
            return partialAlignment.distance - partialAlignment2.distance;
        }
    };
    public static Comparator<PartialAlignment> PARTIAL_COMPARE_TOTAL_ALL = new Comparator<PartialAlignment>(){

        @Override
        public int compare(PartialAlignment partialAlignment, PartialAlignment partialAlignment2) {
            int n = partialAlignment2.matches1 + partialAlignment2.matches2 - (partialAlignment.matches1 + partialAlignment.matches2);
            if (n > 0) {
                return 1;
            }
            if (n < 0) {
                return -1;
            }
            int n2 = partialAlignment2.allMatches1 + partialAlignment2.allMatches2 - (partialAlignment.allMatches1 + partialAlignment.allMatches2);
            if (n2 > 0) {
                return 1;
            }
            if (n2 < 0) {
                return -1;
            }
            int n3 = partialAlignment.chunks - partialAlignment2.chunks;
            if (n3 != 0) {
                return n3;
            }
            return partialAlignment.distance - partialAlignment2.distance;
        }
    };

    public static final boolean isSupported(int n) {
        if (supportedLangIDs == null) {
            supportedLangIDs = new HashSet();
            supportedLangIDs.add(0);
            supportedLangIDs.add(1);
            supportedLangIDs.add(2);
            supportedLangIDs.add(3);
            supportedLangIDs.add(4);
            supportedLangIDs.add(7);
        }
        return supportedLangIDs.contains(n);
    }

    public static String getLangsString() throws RuntimeException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i <= 16; ++i) {
            stringBuilder.append(" ");
            stringBuilder.append(Constants.getLanguageShortName(i));
        }
        return stringBuilder.toString().trim();
    }

    public static int getDefaultTask(int n) {
        if (Constants.isSupported(n)) {
            return 1;
        }
        return 99;
    }

    public static String getLocation() {
        File file = new File(Constants.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        return file.getParent();
    }

    public static URL getDefaultParaFileURL(int n) throws RuntimeException {
        String string = Constants.getLanguageShortName(n);
        String string2 = "/data/paraphrase-" + string + ".gz";
        try {
            return new File(Constants.getLocation() + string2).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException();
        }
    }

    public static URL getDefaultWordFileURL(int n) throws RuntimeException {
        String string = Constants.getLanguageName(n);
        try {
            return new URL(DEFAULT_WORD_DIR_URL.toString() + "/" + string + ".words");
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException();
        }
    }

    public static String normLanguageName(String string) throws RuntimeException {
        String string2 = string.toLowerCase();
        if (string2.equals("english") || string2.equals("en")) {
            return "english";
        }
        if (string2.equals("czech") || string2.equals("cz") || string2.equals("cs")) {
            return "czech";
        }
        if (string2.equals("french") || string2.equals("fr")) {
            return "french";
        }
        if (string2.equals("german") || string2.equals("de")) {
            return "german";
        }
        if (string2.equals("spanish") || string2.equals("es")) {
            return "spanish";
        }
        if (string2.equals("arabic-buckwalter-reduced") || string2.equals("ar-bw-red")) {
            return "arabic-buckwalter-reduced";
        }
        if (string2.equals("portuguese") || string2.equals("pt")) {
            return "portuguese";
        }
        if (string2.equals("russian") || string2.equals("ru")) {
            return "russian";
        }
        if (string2.equals("danish") || string2.equals("da")) {
            return "danish";
        }
        if (string2.equals("romanian") || string2.equals("ro")) {
            return "romanian";
        }
        if (string2.equals("hungarian") || string2.equals("hu")) {
            return "hungarian";
        }
        if (string2.equals("turkish") || string2.equals("tr")) {
            return "turkish";
        }
        if (string2.equals("finnish") || string2.equals("fi")) {
            return "finnish";
        }
        if (string2.equals("dutch") || string2.equals("nl")) {
            return "dutch";
        }
        if (string2.equals("italian") || string2.equals("it")) {
            return "italian";
        }
        if (string2.equals("norwegian") || string2.equals("no")) {
            return "norwegian";
        }
        if (string2.equals("swedish") || string2.equals("se") || string2.equals("sv")) {
            return "swedish";
        }
        if (string2.equals("other") || string2.equals("xx")) {
            return "other";
        }
        throw new RuntimeException("Unknown language (" + string + ")");
    }

    public static int getLanguageID(String string) throws RuntimeException {
        if (string.equals("english")) {
            return 0;
        }
        if (string.equals("czech")) {
            return 1;
        }
        if (string.equals("french")) {
            return 2;
        }
        if (string.equals("spanish")) {
            return 3;
        }
        if (string.equals("german")) {
            return 4;
        }
        if (string.equals("arabic-buckwalter-reduced")) {
            return 5;
        }
        if (string.equals("portuguese")) {
            return 6;
        }
        if (string.equals("russian")) {
            return 7;
        }
        if (string.equals("danish")) {
            return 8;
        }
        if (string.equals("romanian")) {
            return 9;
        }
        if (string.equals("hungarian")) {
            return 10;
        }
        if (string.equals("turkish")) {
            return 11;
        }
        if (string.equals("finnish")) {
            return 12;
        }
        if (string.equals("dutch")) {
            return 13;
        }
        if (string.equals("italian")) {
            return 14;
        }
        if (string.equals("norwegian")) {
            return 15;
        }
        if (string.equals("swedish")) {
            return 16;
        }
        if (string.equals("other")) {
            return 99;
        }
        throw new RuntimeException("Unknown language (" + string + ")");
    }

    public static String getLanguageName(int n) throws RuntimeException {
        if (n == 0) {
            return "english";
        }
        if (n == 1) {
            return "czech";
        }
        if (n == 2) {
            return "french";
        }
        if (n == 3) {
            return "spanish";
        }
        if (n == 4) {
            return "german";
        }
        if (n == 5) {
            return "arabic-buckwalter-reduced";
        }
        if (n == 6) {
            return "portuguese";
        }
        if (n == 7) {
            return "russian";
        }
        if (n == 8) {
            return "danish";
        }
        if (n == 9) {
            return "romanian";
        }
        if (n == 10) {
            return "hungarian";
        }
        if (n == 11) {
            return "turkish";
        }
        if (n == 12) {
            return "finnish";
        }
        if (n == 13) {
            return "dutch";
        }
        if (n == 14) {
            return "italian";
        }
        if (n == 15) {
            return "norwegian";
        }
        if (n == 16) {
            return "swedish";
        }
        if (n == 99) {
            return "other";
        }
        throw new RuntimeException("Unknown language ID (" + n + ")");
    }

    public static String getLanguageShortName(int n) throws RuntimeException {
        if (n == 0) {
            return "en";
        }
        if (n == 1) {
            return "cz";
        }
        if (n == 2) {
            return "fr";
        }
        if (n == 3) {
            return "es";
        }
        if (n == 4) {
            return "de";
        }
        if (n == 5) {
            return "ar-bw-red";
        }
        if (n == 6) {
            return "pt";
        }
        if (n == 7) {
            return "ru";
        }
        if (n == 8) {
            return "da";
        }
        if (n == 9) {
            return "ro";
        }
        if (n == 10) {
            return "hu";
        }
        if (n == 11) {
            return "tr";
        }
        if (n == 12) {
            return "fi";
        }
        if (n == 13) {
            return "nl";
        }
        if (n == 14) {
            return "it";
        }
        if (n == 15) {
            return "no";
        }
        if (n == 16) {
            return "se";
        }
        if (n == 99) {
            return "other";
        }
        throw new RuntimeException("Unknown language ID (" + n + ")");
    }

    public static String getNormName(int n) throws RuntimeException {
        if (n == 0) {
            return "no_norm";
        }
        if (n == 1) {
            return "lc_only";
        }
        if (n == 2) {
            return "norm";
        }
        if (n == 3) {
            return "norm_nopunct";
        }
        throw new RuntimeException("Unknown normalization type (" + n + ")");
    }

    public static int getModuleID(String string) throws RuntimeException {
        String string2 = string.toLowerCase();
        if (string2.equals("exact")) {
            return 0;
        }
        if (string2.equals("stem")) {
            return 1;
        }
        if (string2.equals("synonym")) {
            return 2;
        }
        if (string2.equals("paraphrase")) {
            return 3;
        }
        throw new RuntimeException("Unknown module (" + string + ")");
    }

    public static String getModuleName(int n) throws RuntimeException {
        if (n == 0) {
            return "exact";
        }
        if (n == 1) {
            return "stem";
        }
        if (n == 2) {
            return "synonym";
        }
        if (n == 3) {
            return "paraphrase";
        }
        throw new RuntimeException("Unknown module ID (" + n + ")");
    }

    public static String getModuleShortName(int n) throws RuntimeException {
        if (n == 0) {
            return "ex";
        }
        if (n == 1) {
            return "st";
        }
        if (n == 2) {
            return "sy";
        }
        if (n == 3) {
            return "pa";
        }
        throw new RuntimeException("Unknown module ID (" + n + ")");
    }

    public static String getModuleListString(ArrayList<Integer> arrayList) throws RuntimeException {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuilder.append(Constants.getModuleShortName(arrayList.get(i)));
            if (i >= arrayList.size() - 1) continue;
            stringBuilder.append("_");
        }
        return stringBuilder.toString();
    }

    public static int getTaskID(String string) throws RuntimeException {
        String string2 = string.toLowerCase();
        if (string2.equals("default")) {
            return 1;
        }
        if (string2.equals("adq")) {
            return 0;
        }
        if (string2.equals("rank")) {
            return 1;
        }
        if (string2.equals("hter")) {
            return 2;
        }
        if (string2.equals("li")) {
            return 99;
        }
        if (string2.equals("tune")) {
            return 100;
        }
        if (string2.equals("util")) {
            return 3;
        }
        if (string2.equals("universal")) {
            return 101;
        }
        if (string2.startsWith("custom")) {
            return -1;
        }
        throw new RuntimeException("Unknown task (" + string + ")");
    }

    public static String getTaskName(int n) throws RuntimeException {
        if (n == 0) {
            return "adq";
        }
        if (n == 1) {
            return "rank";
        }
        if (n == 2) {
            return "hter";
        }
        if (n == 99) {
            return "li";
        }
        if (n == 100) {
            return "tune";
        }
        if (n == 3) {
            return "util";
        }
        if (n == 101) {
            return "universal";
        }
        if (n == -1) {
            return "custom";
        }
        throw new RuntimeException("Unknown task ID (" + n + ")");
    }

    public static String getTaskDescription(String string) throws RuntimeException {
        return Constants.getTaskDescription(Constants.getTaskID(string));
    }

    public static String getTaskDescription(int n) throws RuntimeException {
        if (n == 0) {
            return "Adequacy";
        }
        if (n == 1) {
            return "Ranking";
        }
        if (n == 2) {
            return "HTER";
        }
        if (n == 99) {
            return "Language-Independent";
        }
        if (n == 100) {
            return "Tune";
        }
        if (n == 3) {
            return "Translator-Utility";
        }
        if (n == 101) {
            return "Universal";
        }
        if (n == -1) {
            return "Custom";
        }
        throw new RuntimeException("Unknown task ID (" + n + ")");
    }

    public static ArrayList<Double> getParameters(int n, int n2) {
        double[] dArray = n2 == 101 ? PARAM_U : (n == 99 || n2 == 99 ? PARAM_I : (n2 == 100 ? PARAM_TUNE : (n2 == 1 ? PARAM_RANK[n] : (n2 == 2 ? PARAM_HTER[n] : (n2 == 3 ? PARAM_UTIL[n] : PARAM_ADQ[n])))));
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (double d : dArray) {
            arrayList.add(d);
        }
        return arrayList;
    }

    public static ArrayList<Double> getModuleWeights(String string, String string2) throws RuntimeException {
        return Constants.getModuleWeights(Constants.getLanguageID(string), Constants.getTaskID(string2));
    }

    public static ArrayList<Double> getModuleWeights(int n, int n2) {
        double[] dArray = n2 == 101 ? WEIGHT_U : (n == 99 || n2 == 99 ? WEIGHT_I : (n2 == 100 ? WEIGHT_TUNE : (n2 == 1 ? WEIGHT_RANK[n] : (n2 == 2 ? WEIGHT_HTER[n] : (n2 == 3 ? WEIGHT_UTIL[n] : WEIGHT_ADQ[n])))));
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (double d : dArray) {
            arrayList.add(d);
        }
        return arrayList;
    }

    public static String getWeightListString(ArrayList<Double> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuilder.append(arrayList.get(i));
            if (i >= arrayList.size() - 1) continue;
            stringBuilder.append("_");
        }
        return stringBuilder.toString();
    }

    public static Stemmer newStemmer(String string) throws RuntimeException {
        if (string.equals("english")) {
            return new SnowballStemmerWrapper(new englishStemmer());
        }
        if (string.equals("french")) {
            return new SnowballStemmerWrapper(new frenchStemmer());
        }
        if (string.equals("german")) {
            return new SnowballStemmerWrapper(new germanStemmer());
        }
        if (string.equals("spanish")) {
            return new SnowballStemmerWrapper(new spanishStemmer());
        }
        if (string.equals("portuguese")) {
            return new SnowballStemmerWrapper(new portugueseStemmer());
        }
        if (string.equals("russian")) {
            return new SnowballStemmerWrapper(new russianStemmer());
        }
        if (string.equals("danish")) {
            return new SnowballStemmerWrapper(new danishStemmer());
        }
        if (string.equals("romanian")) {
            return new SnowballStemmerWrapper(new romanianStemmer());
        }
        if (string.equals("hungarian")) {
            return new SnowballStemmerWrapper(new hungarianStemmer());
        }
        if (string.equals("turkish")) {
            return new SnowballStemmerWrapper(new turkishStemmer());
        }
        if (string.equals("finnish")) {
            return new SnowballStemmerWrapper(new finnishStemmer());
        }
        if (string.equals("dutch")) {
            return new SnowballStemmerWrapper(new dutchStemmer());
        }
        if (string.equals("italian")) {
            return new SnowballStemmerWrapper(new italianStemmer());
        }
        if (string.equals("norwegian")) {
            return new SnowballStemmerWrapper(new norwegianStemmer());
        }
        if (string.equals("swedish")) {
            return new SnowballStemmerWrapper(new swedishStemmer());
        }
        if (string.equals("arabic-buckwalter-reduced")) {
            try {
                return new LookupTableStemmer(new URL(DEFAULT_STEM_DIR_URL.toString() + "/" + string + ".gz"));
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error loading stemmer for language (" + string + ")");
            }
        }
        throw new RuntimeException("No stemmer for language (" + string + ")");
    }

    public static ArrayList<Integer> getModules(int n, int n2) throws RuntimeException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n2 == 101) {
            arrayList.add(0);
            arrayList.add(3);
        } else if (n == 0) {
            arrayList.add(0);
            arrayList.add(1);
            arrayList.add(2);
            arrayList.add(3);
        } else if (n == 2) {
            arrayList.add(0);
            arrayList.add(1);
            arrayList.add(3);
        } else if (n == 3) {
            arrayList.add(0);
            arrayList.add(1);
            arrayList.add(3);
        } else if (n == 4) {
            arrayList.add(0);
            arrayList.add(1);
            arrayList.add(3);
        } else if (n == 1) {
            arrayList.add(0);
            arrayList.add(3);
        } else if (n == 5) {
            arrayList.add(0);
            arrayList.add(1);
        } else if (n == 6) {
            arrayList.add(0);
            arrayList.add(1);
        } else if (n == 7) {
            arrayList.add(0);
            arrayList.add(1);
            arrayList.add(3);
        } else if (n == 8) {
            arrayList.add(0);
            arrayList.add(1);
        } else if (n == 9) {
            arrayList.add(0);
            arrayList.add(1);
        } else if (n == 10) {
            arrayList.add(0);
            arrayList.add(1);
        } else if (n == 11) {
            arrayList.add(0);
            arrayList.add(1);
        } else if (n == 12) {
            arrayList.add(0);
            arrayList.add(1);
        } else if (n == 13) {
            arrayList.add(0);
            arrayList.add(1);
        } else if (n == 14) {
            arrayList.add(0);
            arrayList.add(1);
        } else if (n == 15) {
            arrayList.add(0);
            arrayList.add(1);
        } else if (n == 16) {
            arrayList.add(0);
            arrayList.add(1);
        } else if (n == 99) {
            arrayList.add(0);
        } else {
            String string = "";
            String string2 = "";
            try {
                string = Constants.getLanguageName(n);
                string2 = Constants.getTaskName(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("No default modules for language and task (" + string + ") (" + string2 + ")");
        }
        return arrayList;
    }
}

