-- This module will transliterate text in the Coptic script. It is used to transliterate Coptic (cop).
-- Language code: cop

local export = {}

local chars = {
	["Ⲁ"] = "A", ["ⲁ"] = "a",
	["Ⲃ"] = "B", ["ⲃ"] = "b",
	["Ⲅ"] = "G", ["ⲅ"] = "g",
	["Ⲇ"] = "D", ["ⲇ"] = "d",
	["Ⲉ"] = "E", ["ⲉ"] = "e",
	["Ⲍ"] = "Z", ["ⲍ"] = "z",
	["Ⲏ"] = "Ē", ["ⲏ"] = "ē",
	["Ⲑ"] = "Th", ["ⲑ"] = "th",
	["Ⲓ"] = "I", ["ⲓ"] = "i",
	["Ⲕ"] = "K", ["ⲕ"] = "k",
	["Ⲗ"] = "L", ["ⲗ"] = "l",
	["Ⲙ"] = "M", ["ⲙ"] = "m",
	["Ⲛ"] = "N", ["ⲛ"] = "n", ["Ⲻ"] = "N", ["ⲻ"] = "n",
	["Ⲝ"] = "Ks", ["ⲝ"] = "ks",
	["Ⲟ"] = "O", ["ⲟ"] = "o",
	["Ⲡ"] = "P", ["ⲡ"] = "p",
	["Ⲣ"] = "R", ["ⲣ"] = "r",
	["Ⲥ"] = "S", ["ⲥ"] = "s",
	["Ⲧ"] = "T", ["ⲧ"] = "t",
	["Ⲩ"] = "U", ["ⲩ"] = "u",
	["Ⲫ"] = "Ph", ["ⲫ"] = "ph",
	["Ⲭ"] = "Kh", ["ⲭ"] = "kh",
	["Ⲯ"] = "Ps", ["ⲯ"] = "ps",
	["Ⲱ"] = "Ō", ["ⲱ"] = "ō",
	["Ϣ"] = "Š", ["ϣ"] = "š",
	["Ϥ"] = "F", ["ϥ"] = "f",
	["Ϧ"] = "X", ["ϧ"] = "x", ["Ⳉ"] = "X", ["ⳉ"] = "x",
	["Ϩ"] = "H", ["ϩ"] = "h",
	["Ϫ"] = "J", ["ϫ"] = "j",
	["Ϭ"] = "Q", ["ϭ"] = "q",
	["Ϯ"] = "Ti", ["ϯ"] = "ti",
	["Ⲹ"] = "K°", ["ⲹ"] = "k°",
	["ⳤ"] = "ke",
	["Ⲳ"] = "ʾ", ["ⲳ"] = "ʾ",
	["Ⳋ"] = "Ç", ["ⳋ"] = "ç", ["Ⳃ"] = "Ç", ["ⳃ"] = "ç",
}

function export.tr(text, lang, sc)
	return (mw.ustring.gsub(text, '.', chars))
end

return export