#ifndef _graphcjj2gc_prune_STATE_H
#define _graphcjj2gc_prune_STATE_H

#include "graphcjj2gc_prune_macros.h"
#include "include/learning/perceptron/score.h"

namespace graphcjj2gc_prune {
	enum STATE{
		L2R_LABEL = 1,
		L2R_NOLABEL,
	};

	class StateItem {
	public:
		int type;
		int left, right;
		ScoreWithBiSplit exact_l2r_label, exact_l2r_nolabel;
		ScoreWithBiSplitAgenda l2r_label;
		ScoreWithBiSplitAgenda l2r_nolabel;

	public:

		StateItem();
		~StateItem();

		void init(const int & l, const int & r);

		void updateL2R_NOLABEL(const int & leftsplit, const int & rightsplit, const tscore & score, const int &label = -1, const int & leftlabel = -1, const int & rightlabel = -1);
		
		void updateL2R_LABEL(const int & leftsplit, const int & rightsplit, const tscore & score,const int &label = -1, const int & leftlabel = -1, const int & rightlabel = -1);
		
		void updateL2R_LABEL(ScoreWithBiSplit swbs);

		void print();
	};

	inline void StateItem::updateL2R_NOLABEL(const int & leftsplit, const int & rightsplit, const tscore & score, const int & label, const int & leftlabel, const int & rightlabel) {
		l2r_nolabel.insertItem(ScoreWithBiSplit(leftsplit, rightsplit, score, label, leftlabel, rightlabel));
	}

	inline void StateItem::updateL2R_LABEL(const int & leftsplit, const int & rightsplit, const tscore & score, const int & label, const int & leftlabel , const int & rightlabel) {
		l2r_label.insertItem(ScoreWithBiSplit(leftsplit,rightsplit, score,label,leftlabel,rightlabel));
	}

	inline void StateItem::updateL2R_LABEL(ScoreWithBiSplit swbs) {
		l2r_label.insertItem(swbs);
	}

	
}

#endif
