/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.modification.io;

import java.util.ArrayList;
import matetools.is2.data.SentenceData09;
import matetools.is2.io.CONLLReader09;

public class CONLLReader08
extends CONLLReader09 {
    public CONLLReader08(String file) {
        super(file);
    }

    public CONLLReader08(String file, int formatTask) {
        super(file, formatTask);
    }

    @Override
    public SentenceData09 getNextCoNLL09() {
        int length;
        ArrayList<String[]> lineList;
        int i;
        block11: {
            String line = null;
            i = 0;
            lineList = new ArrayList<String[]>();
            line = this.inputReader.readLine();
            ++this.lineNumber;
            while (line != null && line.length() == 0) {
                line = this.inputReader.readLine();
                ++this.lineNumber;
                System.out.println("skip empty line at line " + this.lineNumber);
            }
            while (line != null && line.length() != 0 && !line.startsWith("*") && !line.startsWith("\\s+")) {
                lineList.add(line.split("\\s+"));
                line = this.inputReader.readLine();
                ++this.lineNumber;
            }
            length = lineList.size();
            if (length != 0) break block11;
            this.inputReader.close();
            return null;
        }
        try {
            SentenceData09 it = new SentenceData09();
            it.forms = new String[length + 1];
            it.plemmas = new String[length + 1];
            it.gpos = new String[length + 1];
            it.labels = new String[length + 1];
            it.heads = new int[length + 1];
            it.pheads = new int[length + 1];
            it.plabels = new String[length + 1];
            it.ppos = new String[length + 1];
            it.lemmas = new String[length + 1];
            it.fillp = new String[length + 1];
            it.feats = new String[length + 1][];
            it.ofeats = new String[length + 1];
            it.pfeats = new String[length + 1];
            it.id = new String[length + 1];
            it.forms[0] = "<root>";
            it.plemmas[0] = "<root-LEMMA>";
            it.fillp[0] = "N";
            it.lemmas[0] = "<root-LEMMA>";
            it.gpos[0] = "<root-POS>";
            it.ppos[0] = "<root-POS>";
            it.labels[0] = "<no-type>";
            it.heads[0] = -1;
            it.plabels[0] = "<no-type>";
            it.pheads[0] = -1;
            it.ofeats[0] = "<no-type>";
            it.id[0] = "0";
            i = 1;
            while (i <= length) {
                String[] info = (String[])lineList.get(i - 1);
                it.id[i] = info[0];
                it.forms[i] = info[1];
                if (info.length >= 3) {
                    it.plemmas[i] = info[2];
                    it.gpos[i] = info[3];
                    if (info.length >= 5) {
                        it.ppos[i] = info[4];
                        it.ofeats[i] = "_";
                        it.pfeats[i] = "_";
                        it.heads[i] = info[8].equals("_") ? -1 : Integer.parseInt(info[8]);
                        it.pheads[i] = -1;
                        it.labels[i] = info[9];
                        it.plabels[i] = "_";
                        it.fillp[i] = info[10];
                        if (info.length > 11) {
                            if (!info[10].equals("_")) {
                                it.addPredicate(i, info[10]);
                            }
                            int k = 11;
                            while (k < info.length) {
                                it.addArgument(i, k - 11, info[k]);
                                ++k;
                            }
                        }
                    }
                }
                ++i;
            }
            return it;
        }
        catch (Exception e) {
            System.out.println("\n!!! Error in input file sentence before line: " + this.lineNumber + " (in sentence line " + i + " ) " + e.toString());
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }
}

