/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.tag;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import matetools.is2.data.IEncoderPlus;
import matetools.is2.util.DB;

public class Lexicon {
    public static final String FR = "FR";
    public static final String TAG = "TAG";
    final byte[][] word2tag;

    public Lexicon(byte[][] w2t) {
        this.word2tag = w2t;
    }

    public Lexicon(String clusterFile, IEncoderPlus mf) {
        String REGEX = "\t";
        try {
            String line;
            BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(clusterFile), "UTF-8"), 32768);
            int cnt = 0;
            while ((line = inputReader.readLine()) != null) {
                try {
                    String[] split = line.split("\t");
                    ++cnt;
                    mf.register("WORD", split[0]);
                    mf.register(TAG, split[1]);
                    if (split.length <= 1) continue;
                    mf.register(FR, split[1]);
                }
                catch (Exception e) {
                    System.out.println("Error in lexicon line " + cnt + " error: " + e.getMessage());
                }
            }
            System.out.println("read number of words from lexicon " + cnt);
            inputReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.word2tag = new byte[mf.getFeatureCounter().get("WORD").intValue()][1];
        try {
            String line;
            BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(clusterFile), "UTF-8"), 32768);
            while ((line = inputReader.readLine()) != null) {
                String[] split = line.split("\t");
                int w = mf.getValue("WORD", split[0]);
                if (w < 0) continue;
                this.word2tag[w][0] = (byte)mf.getValue(TAG, split[1]);
            }
            inputReader.close();
            int fill = 0;
            int l = 0;
            while (l < this.word2tag.length) {
                if (this.word2tag[l][0] != 0) {
                    ++fill;
                }
                ++l;
            }
            System.out.println("filled " + fill + " of " + this.word2tag.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Lexicon(DataInputStream dis) throws IOException {
        this.word2tag = new byte[dis.readInt()][1];
        int i = 0;
        while (i < this.word2tag.length) {
            this.word2tag[i][0] = dis.readByte();
            ++i;
        }
        DB.println("Read lexicon with " + this.word2tag.length + " words ");
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.word2tag.length);
        byte[][] byArray = this.word2tag;
        int n = this.word2tag.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] i = byArray[n2];
            dos.writeByte(i[0]);
            ++n2;
        }
    }

    public int getTag(int form) {
        if (this.word2tag.length < form || form < 0) {
            return -1;
        }
        return this.word2tag[form][0];
    }

    public int getConf(int form) {
        if (this.word2tag.length < form || form < 0) {
            return -1;
        }
        return this.word2tag[form][1];
    }
}

