/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.modification.costsensitive;

import edu.pku.coli.semantics.DelphinStringUtil;
import java.util.HashSet;
import java.util.Set;
import matetools.is2.data.FV;
import matetools.is2.data.Instances;
import matetools.is2.data.Parse;
import matetools.is2.modification.costsensitive.CostStrategy;
import matetools.is2.parser.ParametersFloat;

public class UASCostStrategy
implements CostStrategy {
    public double C = 1.0;
    public double taskRelatedness = 1.0;
    static Set<String> punct = new HashSet<String>();
    static final String cc = "CC";

    public UASCostStrategy(double c) {
        punct.add("``");
        punct.add(",");
        punct.add(":");
        punct.add(".");
        punct.add("''");
        punct.add("(");
        punct.add(")");
        punct.add("$");
        punct.add("#");
        this.C = c;
    }

    public UASCostStrategy(double c, double r) {
        punct.add("``");
        punct.add(",");
        punct.add(":");
        punct.add(".");
        punct.add("''");
        punct.add("(");
        punct.add(")");
        punct.add("$");
        punct.add("#");
        this.C = c;
        this.taskRelatedness = r;
    }

    double cost(Instances is, int n, Parse d) {
        short[] gold = is.heads[n];
        short[] sys = d.heads;
        double wrong = 0.0;
        if (is.additional[n]) {
            int i = 0;
            while (i < gold.length) {
                boolean dontcare;
                boolean bl = dontcare = is.gstrpos[n][i].equals(cc) || sys[i] > 0 && is.gstrpos[n][sys[i]].equals(cc) || DelphinStringUtil.isPunctPTB((String)is.gstrpos[n][i]);
                if (!dontcare && gold[i] != sys[i]) {
                    wrong += 1.0;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < gold.length) {
                if (gold[i] != sys[i]) {
                    wrong += 1.0;
                }
                ++i;
            }
        }
        return wrong / (double)gold.length;
    }

    @Override
    public double calculate(Instances is, int n, Parse d, ParametersFloat curParams, FV act, FV pred) {
        double uas = this.cost(is, n, d);
        if (uas == 0.0) {
            return 0.0;
        }
        float lam_dist = curParams.getScore(act) - curParams.getScore(pred);
        FV dist = act.getDistVector(pred);
        double norm = dist.dotProduct(dist);
        double u = Math.sqrt(uas) - (double)lam_dist;
        double l = norm + 0.5 / this.C;
        if (is.additional[n]) {
            return u / l * this.taskRelatedness;
        }
        return u / l;
    }
}

