/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.IOUtils;
import fig.basic.ListUtils;
import fig.basic.StatFig;
import fig.record.Recordable;
import java.io.PrintWriter;
import java.util.List;

public class Record {
    private static int indent;
    private static PrintWriter out;

    public static void init(String path) {
        out = IOUtils.openOutEasy(path);
    }

    public static void finish() {
        if (out != null) {
            out.close();
        }
    }

    public static void flush() {
        if (out != null) {
            out.flush();
        }
    }

    private static void print(Object o) {
        if (out == null) {
            return;
        }
        int i = 0;
        while (i < indent) {
            out.print('\t');
            ++i;
        }
        out.println("" + o);
    }

    public static void setStruct(Object ... keys) {
        Record.addTabSepValues(".struct", keys);
    }

    public static void clearStruct() {
        Record.add(".struct", new Object[0]);
    }

    public static void add(String key, Object ... val) {
        Record.addTabSepValues(key, val);
    }

    public static <T> void addArray(String key, int[] values) {
        Record.addArray(key, ListUtils.toObjArray(values));
    }

    public static <T> void addArray(String key, double[] values) {
        Record.addArray(key, ListUtils.toObjArray(values));
    }

    public static <T> void addArray(String key, T[] values) {
        StringBuilder buf = new StringBuilder();
        buf.append(".array\t");
        buf.append(key);
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            buf.append('\t');
            buf.append(value);
            ++n2;
        }
        Record.print(buf.toString());
    }

    public static void addArray(String key, List values) {
        StringBuilder buf = new StringBuilder();
        buf.append(".array\t");
        buf.append(key);
        for (Object value : values) {
            buf.append('\t');
            buf.append(value);
        }
        Record.print(buf.toString());
    }

    public static void addObject(Object o, Object arg) {
        if (o instanceof Recordable) {
            ((Recordable)o).record(arg);
        } else if (o instanceof List) {
            List l = (List)o;
            if (l.size() != 0 && l.get(0) instanceof Recordable) {
                int i = 0;
                while (i < l.size()) {
                    Record.addEmbedArg("index", i, l.get(i), arg);
                    ++i;
                }
            } else {
                Record.setStruct("index", "value");
                int i = 0;
                while (i < l.size()) {
                    Record.add("" + i, l.get(i));
                    ++i;
                }
            }
        } else if (o instanceof StatFig) {
            StatFig f = (StatFig)o;
            Record.add("n", f.count());
            Record.add("mean", f.mean());
            Record.add("stddev", f.stddev());
            Record.add("min", f.min());
            Record.add("max", f.max());
        } else {
            Record.add("value", o);
        }
    }

    public static void addEmbed(String key, Object o) {
        Record.addEmbedArg(key, o, null);
    }

    public static void addEmbed(String key, Object val, Object o) {
        Record.addEmbedArg(key, val, o, null);
    }

    public static void addEmbedArg(String key, Object o, Object arg) {
        Record.begin(key);
        Record.addObject(o, arg);
        Record.end();
    }

    public static void addEmbedArg(String key, Object val, Object o, Object arg) {
        Record.begin(key, val);
        Record.addObject(o, arg);
        Record.end();
    }

    public static synchronized void begin(String key) {
        Record.add(key, new Object[0]);
        ++indent;
    }

    public static synchronized void begin(String key, Object val) {
        Record.add(key, val);
        ++indent;
    }

    public static synchronized void end() {
        --indent;
        Record.flush();
    }

    private static void addTabSepValues(String a, Object[] b) {
        StringBuilder buf = new StringBuilder();
        buf.append(a);
        Object[] objectArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            buf.append('\t');
            buf.append(o);
            ++n2;
        }
        Record.print(buf.toString());
    }
}

