/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.ListUtils;
import fig.basic.StrUtils;
import fig.prob.SuffStats;

public class MultinomialSuffStats
implements SuffStats {
    private double[] counts;
    private double totalCount;

    public MultinomialSuffStats(int numDim) {
        this.counts = new double[numDim];
        this.totalCount = 0.0;
    }

    public MultinomialSuffStats(double[] x) {
        this.counts = x;
        this.totalCount = ListUtils.sum(x);
    }

    public MultinomialSuffStats(int numDim, int i) {
        this.counts = new double[numDim];
        int n = i;
        this.counts[n] = this.counts[n] + 1.0;
        this.totalCount = 1.0;
    }

    public MultinomialSuffStats(double[] counts, double totalCount) {
        this.counts = counts;
        this.totalCount = totalCount;
    }

    public MultinomialSuffStats(MultinomialSuffStats stats) {
        this.counts = (double[])stats.counts.clone();
        this.totalCount = stats.totalCount;
    }

    @Override
    public void add(SuffStats _suffStats) {
        MultinomialSuffStats suffStats = (MultinomialSuffStats)_suffStats;
        ListUtils.incr(this.counts, 1.0, suffStats.counts);
        this.totalCount += suffStats.totalCount;
    }

    @Override
    public void sub(SuffStats _suffStats) {
        MultinomialSuffStats suffStats = (MultinomialSuffStats)_suffStats;
        ListUtils.incr(this.counts, -1.0, suffStats.counts);
        this.totalCount -= suffStats.totalCount;
    }

    public void add(int i, double x) {
        int n = i;
        this.counts[n] = this.counts[n] + x;
        this.totalCount += x;
    }

    @Override
    public SuffStats reweight(double scale) {
        return new MultinomialSuffStats(ListUtils.mult(scale, this.counts), scale * this.totalCount);
    }

    public double getCount(int i) {
        return this.counts[i];
    }

    public double[] getCounts() {
        return this.counts;
    }

    public int dim() {
        return this.counts.length;
    }

    public double totalCount() {
        return this.totalCount;
    }

    public String toString() {
        return "counts(" + StrUtils.join(this.counts) + ")";
    }
}

