/*
 * Decompiled with CFR 0.152.
 */
package jigsaw.metrics;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import jigsaw.metrics.Evalb;
import jigsaw.metrics.TaggingCatEval;
import jigsaw.syntax.Constituent;
import jigsaw.syntax.Tree;

public class CatEvalb
extends Evalb {
    HashMap<String, Double> catGold = new HashMap();
    HashMap<String, Double> catGuess = new HashMap();
    HashMap<String, Double> catPrecision = new HashMap();
    HashMap<String, Double> catRecall = new HashMap();

    public CatEvalb(String str, boolean runningAverages) {
        super(str, runningAverages);
    }

    @Override
    public void evaluate(Tree<String> guess, Tree<String> gold, PrintWriter pw, double weight) {
        if (gold == null || guess == null) {
            System.err.printf("%s: Cannot compare against a null gold or guess tree!\n", this.getClass().getName());
            return;
        }
        Set<Constituent<String>> dep1 = this.makeObjects(guess);
        Set<Constituent<String>> dep2 = this.makeObjects(gold);
        double curPrecision = CatEvalb.precision(dep1, dep2);
        double curRecall = CatEvalb.precision(dep2, dep1);
        this.recordCat(dep1, dep2, weight);
        this.curF1 = curPrecision > 0.0 && curRecall > 0.0 ? 2.0 / (1.0 / curPrecision + 1.0 / curRecall) : 0.0;
        this.precision += curPrecision * weight;
        this.recall += curRecall * weight;
        this.f1 += this.curF1 * weight;
        this.num += weight;
        this.precision2 += (double)dep1.size() * curPrecision * weight;
        this.pnum2 += (double)dep1.size() * weight;
        this.recall2 += (double)dep2.size() * curRecall * weight;
        this.rnum2 += (double)dep2.size() * weight;
        if (this.curF1 > 0.9999) {
            this.exact += 1.0;
        }
        if (pw != null) {
            double cF1 = 2.0 / (this.rnum2 / this.recall2 + this.pnum2 / this.precision2);
            pw.format("%s [current] P: %.2f R: %.2f F1: %.2f", this.str, curPrecision * 100.0, curRecall * 100.0, this.curF1 * 100.0);
            if (this.runningAverages) {
                pw.format(" - [average] P: %.2f R: %.2f F1: %.2f Ex: %.2f N: %d", this.precision2 * 100.0 / this.pnum2, this.recall2 * 100.0 / this.rnum2, cF1 * 100.0, 100.0 * this.exact / this.num, this.getNum());
            }
            pw.println();
        }
    }

    public void increaseCatGold(String cat, double count) {
        double c = count + (this.catGold.containsKey(cat) ? this.catGold.get(cat) : 0.0);
        this.catGold.put(cat, c);
    }

    public void increaseCatGuess(String cat, double count) {
        double c = count + (this.catGuess.containsKey(cat) ? this.catGuess.get(cat) : 0.0);
        this.catGuess.put(cat, c);
    }

    public void increaseCatPrecision(String cat, double count) {
        double c = count + (this.catPrecision.containsKey(cat) ? this.catPrecision.get(cat) : 0.0);
        this.catPrecision.put(cat, c);
    }

    public void increaseCatRecall(String cat, double count) {
        double c = count + (this.catRecall.containsKey(cat) ? this.catRecall.get(cat) : 0.0);
        this.catRecall.put(cat, c);
    }

    public void recordCat(Set<Constituent<String>> guessSet, Set<Constituent<String>> goldSet, double weight) {
        for (Constituent<String> guess : guessSet) {
            String guesscat = guess.getLabel();
            this.increaseCatGuess(guesscat, weight);
            if (!goldSet.contains(guess)) continue;
            this.increaseCatPrecision(guesscat, weight);
        }
        for (Constituent<String> gold : goldSet) {
            String goldcat = gold.getLabel();
            this.increaseCatGold(goldcat, weight);
            if (!guessSet.contains(gold)) continue;
            this.increaseCatRecall(goldcat, weight);
        }
    }

    @Override
    public void display(boolean verbose, PrintWriter pw) {
        double prec = this.precision2 / this.pnum2;
        double rec = this.recall2 / this.rnum2;
        double f = 2.0 / (1.0 / prec + 1.0 / rec);
        pw.format("%s [summary]: LP: %.2f LR: %.2f F1: %.2f Ex: %.2f N: %d%n", this.str, 100.0 * prec, 100.0 * rec, 100.0 * f, 100.0 * this.exact / this.num, this.getNum());
        if (verbose) {
            HashMap<String, Double> catP = new HashMap<String, Double>();
            for (String cat : this.catGuess.keySet()) {
                catP.put(cat, (this.catPrecision.containsKey(cat) ? this.catPrecision.get(cat) : 0.0) / this.catGuess.get(cat));
            }
            HashMap<String, Double> catR = new HashMap<String, Double>();
            for (String cat : this.catGold.keySet()) {
                catR.put(cat, (this.catRecall.containsKey(cat) ? this.catRecall.get(cat) : 0.0) / this.catGold.get(cat));
            }
            HashMap<String, Double> catF1 = new HashMap<String, Double>();
            for (String cat : this.catGold.keySet()) {
                double p = catP.containsKey(cat) ? (Double)catP.get(cat) : 0.0;
                double r = catR.containsKey(cat) ? (Double)catR.get(cat) : 0.0;
                double f1 = p > 0.0 && r > 0.0 ? 2.0 / (1.0 / p + 1.0 / r) : 0.0;
                catF1.put(cat, f1);
            }
            pw.println("Top low precision categories : ");
            List catplist = TaggingCatEval.SortByValue(catP);
            int i = 0;
            while (i < catplist.size()) {
                String cat = (String)catplist.get(i);
                pw.format(" %s : %.0f / %.0f = %.2f %n", cat, this.catPrecision.containsKey(cat) ? this.catPrecision.get(cat) : 0.0, this.catGuess.get(cat), (Double)catP.get(cat) * 100.0);
                ++i;
            }
            pw.println("Top low recall categories : ");
            List catrlist = TaggingCatEval.SortByValue(catR);
            int i2 = 0;
            while (i2 < catrlist.size()) {
                String cat = (String)catrlist.get(i2);
                pw.format(" %s : %.0f / %.0f = %.2f %n", cat, this.catRecall.containsKey(cat) ? this.catRecall.get(cat) : 0.0, this.catGold.get(cat), (Double)catR.get(cat) * 100.0);
                ++i2;
            }
            pw.println("Top low F1 categories : ");
            List catf1list = TaggingCatEval.SortByValue(catF1);
            int i3 = 0;
            while (i3 < catf1list.size()) {
                String cat = (String)catf1list.get(i3);
                pw.format(" %s : P=%.0f/%.0f=%.2f R=%.0f/%.0f=%.2f F1=%.2f %n", cat, this.catPrecision.containsKey(cat) ? this.catPrecision.get(cat) : 0.0, this.catGuess.containsKey(cat) ? this.catGuess.get(cat) : 0.0, catP.containsKey(cat) ? (Double)catP.get(cat) * 100.0 : 0.0, this.catRecall.containsKey(cat) ? this.catRecall.get(cat) : 0.0, this.catGold.containsKey(cat) ? this.catGold.get(cat) : 0.0, catR.containsKey(cat) ? (Double)catR.get(cat) * 100.0 : 0.0, (Double)catF1.get(cat) * 100.0);
                ++i3;
            }
        }
    }
}

