/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.Exceptions;
import fig.prob.Distrib;
import fig.prob.MargDistrib;
import fig.prob.SuffStats;
import java.util.Random;

public class TemperedMargDistrib<T extends Distrib>
implements MargDistrib<T> {
    private MargDistrib<T> distrib;
    private double temperature;

    public TemperedMargDistrib(MargDistrib<T> distrib, double temperature) {
        this.distrib = distrib;
        this.temperature = temperature;
    }

    @Override
    public double margLogLikelihood(SuffStats stats) {
        return this.distrib.margLogLikelihood(stats) / this.temperature;
    }

    @Override
    public double predLogLikelihood(SuffStats condStats, SuffStats predStats) {
        return this.distrib.predLogLikelihood(condStats, predStats) / this.temperature;
    }

    @Override
    public MargDistrib getPosterior(SuffStats stats) {
        return new TemperedMargDistrib<T>(this.distrib.getPosterior(stats), this.temperature);
    }

    @Override
    public double expectedLogLikelihood(SuffStats stats) {
        throw Exceptions.unsupported;
    }

    @Override
    public double logProb(SuffStats stats) {
        throw Exceptions.unsupported;
    }

    @Override
    public double logProbObject(T x) {
        throw Exceptions.unsupported;
    }

    @Override
    public T sampleObject(Random random) {
        throw Exceptions.unsupported;
    }

    @Override
    public double crossEntropy(Distrib<T> distrib) {
        throw Exceptions.unsupported;
    }
}

