/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PStack;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.event.EventListenerList;

public class PPickPath
implements PInputEventListener {
    public static PPickPath CURRENT_PICK_PATH;
    private static final double[] PTS;
    private PStack nodeStack;
    private final PCamera topCamera;
    private PStack transformStack;
    private PStack pickBoundsStack = new PStack();
    private PCamera bottomCamera;
    private HashMap excludedNodes;
    static /* synthetic */ Class class$edu$umd$cs$piccolo$event$PInputEventListener;

    public PPickPath(PCamera pCamera, PBounds pBounds) {
        this.topCamera = pCamera;
        this.nodeStack = new PStack();
        this.transformStack = new PStack();
        this.pickBoundsStack.push(pBounds);
        CURRENT_PICK_PATH = this;
    }

    public PBounds getPickBounds() {
        return (PBounds)this.pickBoundsStack.peek();
    }

    public boolean acceptsNode(PNode pNode) {
        return this.excludedNodes == null || !this.excludedNodes.containsKey(pNode);
    }

    public void pushNode(PNode pNode) {
        this.nodeStack.push(pNode);
    }

    public void popNode(PNode pNode) {
        this.nodeStack.pop();
    }

    public PNode getPickedNode() {
        return (PNode)this.nodeStack.peek();
    }

    public PNode nextPickedNode() {
        PNode pNode = this.getPickedNode();
        if (pNode == this.topCamera) {
            return null;
        }
        if (this.excludedNodes == null) {
            this.excludedNodes = new HashMap();
        }
        this.excludedNodes.put(pNode, pNode);
        Object e = this.pickBoundsStack.get(0);
        this.pickBoundsStack = new PStack();
        this.nodeStack = new PStack();
        this.transformStack = new PStack();
        this.pickBoundsStack = new PStack();
        this.pickBoundsStack.push(e);
        this.topCamera.fullPick(this);
        if (this.getNodeStackReference().size() == 0) {
            this.pushNode(this.topCamera);
            this.pushTransform(this.topCamera.getTransformReference(false));
        }
        return this.getPickedNode();
    }

    public PCamera getTopCamera() {
        return this.topCamera;
    }

    public PCamera getBottomCamera() {
        if (this.bottomCamera == null) {
            this.bottomCamera = this.calculateBottomCamera();
        }
        return this.bottomCamera;
    }

    private PCamera calculateBottomCamera() {
        for (int i = this.nodeStack.size() - 1; i >= 0; --i) {
            PNode pNode = (PNode)this.nodeStack.get(i);
            if (!(pNode instanceof PCamera)) continue;
            return (PCamera)pNode;
        }
        return null;
    }

    public PStack getNodeStackReference() {
        return this.nodeStack;
    }

    public double getScale() {
        PPickPath.PTS[0] = 0.0;
        PPickPath.PTS[1] = 0.0;
        PPickPath.PTS[2] = 1.0;
        PPickPath.PTS[3] = 0.0;
        int n = this.transformStack.size();
        for (int i = 0; i < n; ++i) {
            PAffineTransform pAffineTransform = ((PTuple)this.transformStack.get((int)i)).transform;
            if (pAffineTransform == null) continue;
            pAffineTransform.transform(PTS, 0, PTS, 0, 2);
        }
        return Point2D.distance(PTS[0], PTS[1], PTS[2], PTS[3]);
    }

    public void pushTransform(PAffineTransform pAffineTransform) {
        this.transformStack.push(new PTuple(this.getPickedNode(), pAffineTransform));
        if (pAffineTransform != null) {
            Rectangle2D rectangle2D = (Rectangle2D)this.getPickBounds().clone();
            pAffineTransform.inverseTransform(rectangle2D, rectangle2D);
            this.pickBoundsStack.push(rectangle2D);
        }
    }

    public void popTransform(PAffineTransform pAffineTransform) {
        this.transformStack.pop();
        if (pAffineTransform != null) {
            this.pickBoundsStack.pop();
        }
    }

    public PAffineTransform getPathTransformTo(PNode pNode) {
        PAffineTransform pAffineTransform = new PAffineTransform();
        int n = this.transformStack.size();
        for (int i = 0; i < n; ++i) {
            PTuple pTuple = (PTuple)this.transformStack.get(i);
            if (pTuple.transform != null) {
                pAffineTransform.concatenate(pTuple.transform);
            }
            if (pNode != pTuple.node) continue;
            return pAffineTransform;
        }
        throw new RuntimeException("Node could not be found on pick path");
    }

    public void processEvent(PInputEvent pInputEvent, int n) {
        pInputEvent.setPath(this);
        for (int i = this.nodeStack.size() - 1; i >= 0; --i) {
            PNode pNode = (PNode)this.nodeStack.get(i);
            EventListenerList eventListenerList = pNode.getListenerList();
            if (eventListenerList == null) continue;
            EventListener[] eventListenerArray = eventListenerList.getListeners(class$edu$umd$cs$piccolo$event$PInputEventListener == null ? PPickPath.class$("edu.umd.cs.piccolo.event.PInputEventListener") : class$edu$umd$cs$piccolo$event$PInputEventListener);
            for (int j = 0; j < eventListenerArray.length; ++j) {
                PInputEventListener pInputEventListener = (PInputEventListener)eventListenerArray[j];
                pInputEventListener.processEvent(pInputEvent, n);
                if (!pInputEvent.isHandled()) continue;
                return;
            }
        }
    }

    public Point2D canvasToLocal(Point2D point2D, PNode pNode) {
        return this.getPathTransformTo(pNode).inverseTransform(point2D, point2D);
    }

    public Dimension2D canvasToLocal(Dimension2D dimension2D, PNode pNode) {
        return this.getPathTransformTo(pNode).inverseTransform(dimension2D, dimension2D);
    }

    public Rectangle2D canvasToLocal(Rectangle2D rectangle2D, PNode pNode) {
        return this.getPathTransformTo(pNode).inverseTransform(rectangle2D, rectangle2D);
    }

    static {
        PTS = new double[4];
    }

    private static class PTuple {
        public PNode node;
        public PAffineTransform transform;

        public PTuple(PNode pNode, PAffineTransform pAffineTransform) {
            this.node = pNode;
            this.transform = pAffineTransform;
        }
    }
}

