
#load "str.cma";;

open Str
open String

type 'a untyped_list = End | Term of 'a | UntypedList of 'a untyped_list * 'a untyped_list;;

let rec build_tree = function
    s when length s = 0 ->
      s, End
  | s when get s 0 = ' ' ->
      build_tree (string_after s 1)
  | s when get s 0 = '(' ->
      let r, t0 = build_tree (string_after s 1) in
      let r, t  = build_tree r in
      r, UntypedList(t0, t)
  | s when get s 0 = ')' ->
      (string_after s 1), End
  | s when string_match (regexp "[^ ()]+") s 0 ->
      let c = matched_string s in
      let r, t = build_tree (string_after s (match_end ())) in
      r, UntypedList ( Term ( c ), t )
  | s ->
      s, End;;


let rec tree2str = function
    UntypedList(Term(s),End) -> s
  | UntypedList(Term(s),t)   -> s^" "^(tree2str t)
  | UntypedList(tc,End)      -> "("^(tree2str tc)^")"
  | UntypedList(tc,t)        -> "("^(tree2str tc)^") "^(tree2str t)
  | Term(s)                  -> s
  | End                      -> "";;


try
  while true do
    let s = input_line stdin in     (* "(S (NP the cat) (VP sat down))" in *)
    let r,t = build_tree s in
    print_endline (tree2str t)
  done;
  None
with
  End_of_file -> None
;;



