///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "nl-cpt.h"
#include <string>
#include <vector>
#include <iostream>
#include <cstdio>
#include <sstream>
using namespace std;

char psX[] = "";
char psSlash[] = "/";
char psVetical[] = "|";
char psComma[] = ",";
char psSemi[] = ";";
char psSemiSemi[] = ";;";
char psDelim[] = "_";
char psDashDiamondDash[] = "-<>-";
char psTilde[] = "~";
//char psBar[]="|";
//char psOpenBrace[]="{";
//char psCloseBrace[]="}";
char psLangle[] = "<";
char psRangle[] = ">";
char psLbrack[] = "[";
char psRbrack[] = "]";
const char* OLD = "old";
const char* NEW = "NEW";
const char* COPY = "copy";
const unsigned int maxlen = 6;
//const string& underline = "_";
//const char* COPY = "COPY";
/* G;OP */
/* CR;POS;OP */
/* IND/GEN;POS;OP */
/* 0/0;0;0 */

//my BEG_STATE and END_STATE is based on the model,
//H is equal to S and S is composed of OP,CR and POS
//CR is composed of Ind, Gen,Num and Syn
//Therefore, I have the following:
//const char* BEG_STATE = "-;-|-|-|-;-";
//const char* END_STATE = "-;-|-|-|-;-";

//const char* BEG_STATE = "-;-,-|-_-_-_-_-_-,-|-_-_-_-_-_-,-|-_-_-_-_-_-,-;-";
//const char* END_STATE = "-;-,-|-_-_-_-_-_-,-|-_-_-_-_-_-,-|-_-_-_-_-_-,-;-";

//const char* BEG_STATE = "S/end;-/-;-/-/-;-/-;-;;0/0;0;0";
//const char* END_STATE = "S/end;-/-;-/-/-;-/-;-;;0/0;0;0";

const char* BEG_STATE = "-;-,-|-_-_-_-_-_-|-_-_-_-_-_-|-_-_-_-_-_-;-";
const char* END_STATE = "-;-,-|-_-_-_-_-_-|-_-_-_-_-_-|-_-_-_-_-_-;-";

const int GENNUM = 5;
string genArray[GENNUM] = {"UNK", "NEU", "FAM","MAS","-"};
const int NUMNUM = 4;
string numArray[NUMNUM] = {"UNK", "SING", "PLUR","-"};
const int SYNNUM = 30;
string synArray[SYNNUM] = {"A", "OBJ", "I-OBJ","P","F-SUBJ","NOM","PCOMPL-S","CC","SYMBOL",
		",","O-ADVL","AD-A","ADVL","APP","NOM-OF","NOM",".","P-FAMINV","DN","VOC","NH",
		"-FMAINV","+FMAINV","CS","QN",")","+FAUXV","-FAUXV","PCOMPL-O","-"};

void Tokenize(const string& str, vector<string>& tokens,
		const string& delimiters) {
	// Skip delimiters at beginning.
	string::size_type lastPos = str.find_first_not_of(delimiters, 0);
	// Find first "non-delimiter".
	string::size_type pos = str.find_first_of(delimiters, lastPos);

	while (string::npos != pos || string::npos != lastPos) {
		// Found a token, add it to the vector.
		tokens.push_back(str.substr(lastPos, pos - lastPos));
		// Skip delimiters.  Note the "not_of"
		lastPos = str.find_first_not_of(delimiters, pos);
		// Find next "non-delimiter"
		pos = str.find_first_of(delimiters, lastPos);
	}
}

////////////////////////////////////////////////////////////////////////////////
//
//  Random Variables
//
////////////////////////////////////////////////////////////////////////////////

//const Pos Pos_0("-");
DiscreteDomain<int> domOP;
typedef DiscreteDomainRV<int, domOP> OP;
const OP Op_BOT("-");
const OP Op_COPY(COPY);
const OP Op_OLD(OLD);
const OP Op_NEW(NEW);

DiscreteDomain<int> domLoc;
typedef DiscreteDomainRV<int, domLoc> Loc;
//class Loc : public DiscreteDomainRV<int,domLoc> {
// public:
//  Loc ( )                : DiscreteDomainRV<int,domLoc> ( )    { }
//  Loc ( int i )          : DiscreteDomainRV<int,domLoc> ( i )  { }
//  Loc ( const char* ps ) : DiscreteDomainRV<int,domLoc> ( ps ) { }
//};
const Loc Loc_BOT("-");

DiscreteDomain<int> domSize;
typedef DiscreteDomainRV<int, domSize> Size;
//class Size : public DiscreteDomainRV<char,domSize> {
// public:
//  Size ( )                : DiscreteDomainRV<char,domSize> ( )    { }
//  Size ( int i )          : DiscreteDomainRV<char,domSize> ( i )  { }
//  Size ( const char* ps ) : DiscreteDomainRV<char,domSize> ( ps ) { }
//};
const Size Size_BOT("-");

class JointInd: public DelimitedJoint2DRV<psX, Loc, psComma, Size, psX> {
public:
	JointInd() :
		DelimitedJoint2DRV<psX, Loc, psComma, Size, psX> () {
	}
	JointInd(char* ps) :
		DelimitedJoint2DRV<psX, Loc, psComma, Size, psX> (ps) {
	}
	JointInd(const Loc & loc, const Size & size) :
		DelimitedJoint2DRV<psX, Loc, psComma, Size, psX> (loc, size) {
	}
	bool compareFinal(const JointInd& jointInd) const {
		return (*this == jointInd);
	}
};

DiscreteDomain<int> domNewGen;
typedef DiscreteDomainRV<int, domNewGen> NewGen;
const NewGen NewGen_BOT("-");

typedef DelimitedJointArrayRV<maxlen, psDelim, NewGen> Gen;

DiscreteDomain<int> domNewNum;
typedef DiscreteDomainRV<int, domNewNum> NewNum;
const NewNum NewNum_BOT("-");

typedef DelimitedJointArrayRV<maxlen, psDelim, NewNum> Num;

DiscreteDomain<int> domNewSyn;
typedef DiscreteDomainRV<int, domNewSyn> NewSyn;
const NewSyn NewSyn_BOT("-");
typedef DelimitedJointArrayRV<maxlen, psDelim, NewSyn> Syn;

DiscreteDomain<int> domPos;
typedef DiscreteDomainRV<int, domPos> Pos;
const Pos Pos_BOT("-");

//class CR : public DelimitedJoint4DRV<psX,Ind,psSlash,Gen,psSlash,Num,psSlash, Syn,psX> {
//public:
//	CR ( )                                                  : DelimitedJoint4DRV<psX,Ind,psSlash,Gen,psSlash,Num,psSlash,Syn,psX> ( )    { }
//	CR ( char* ps )                                         : DelimitedJoint4DRV<psX,Ind,psSlash,Gen,psSlash,Num,psSlash,Syn,psX> ( ps ) { }
//	CR ( const Ind& ind, const Gen& gen, const Num & num,const Syn & syn )                  : DelimitedJoint4DRV<psX,Ind,psSlash,Gen,psSlash,Num,psSlash,Syn,psX> ( ind, gen,num,syn ) { }
//};

class CR: public DelimitedJoint4DRV<psX, JointInd, psVetical, Gen, psVetical,
Num, psVetical, Syn, psX> {
public:
	CR() :
		DelimitedJoint4DRV<psX, JointInd, psVetical, Gen, psVetical, Num,
		psVetical, Syn, psX> () {
	}
	CR(char* ps) :
		DelimitedJoint4DRV<psX, JointInd, psVetical, Gen, psVetical, Num,
		psVetical, Syn, psX> (ps) {
	}
	CR(const JointInd& joint_ind, const Gen& gen, const Num & num,
			const Syn & syn) :
				DelimitedJoint4DRV<psX, JointInd, psVetical, Gen, psVetical, Num,
				psVetical, Syn, psX> (joint_ind, gen, num, syn) {
	}
};

//// H: the set of all (marginalized) reduce and (modeled) shift variables in the HHMM...

class G: public DelimitedJoint2DRV<psX, CR, psSemi, Pos, psX> {
public:
	G() :
		DelimitedJoint2DRV<psX, CR, psSemi, Pos, psX> () {
	}
	G(char* ps) :
		DelimitedJoint2DRV<psX, CR, psSemi, Pos, psX> (ps) {
	}
	G(const CR & cr, const Pos & pos) :
		DelimitedJoint2DRV<psX, CR, psSemi, Pos, psX> (cr, pos) {
	}
	bool compareFinal(const G& g) const {
		return (*this == g);
	}
};

class S: public DelimitedJoint2DRV<psX, OP, psSemi, G, psX> {
public:
	S() :
		DelimitedJoint2DRV<psX, OP, psSemi, G, psX> () {
	}
	S(char* ps) :
		DelimitedJoint2DRV<psX, OP, psSemi, G, psX> (ps) {
	}
	S(const OP & op, const G g) :
		DelimitedJoint2DRV<psX, OP, psSemi, G, psX> (op, g) {
	}
	operator OP() const {
		return first;
	}
	//this following is for convenience to store Observed Model into a simplehash<Pos, prob> defined in TextObsModel-corefS;
	operator G() const {
		return second;
	}
	operator Pos() const {
		return second.second;
	}

	bool compareFinal(const S& s) const {
		return (*this == s);
	}
};

typedef S H;

//// L: letter...
DiscreteDomain<char> domainLt;
typedef DiscreteDomainRV<char, domainLt> Lt;

//// W: word (array of letters, arranged last to first)...
//typedef StaticSafeArray<5,Lt> W;
DiscreteDomain<int> domainW;
class W: public DiscreteDomainRV<int, domainW> , public StaticSafeArray<5, Lt> {
public:
	W() {
	}
	W(const char* ps) :
		DiscreteDomainRV<int, domainW> (ps) {
		char psTemp[2] = "-";
		int n = strlen(ps);
		for (int i = 0; i < 5; i++) {
			psTemp[0] = (i < n) ? ps[n - i - 1] : '_';
			//cout<<"!!!!!!!!!!!!!!!!!!"<<psTemp<<endl;
			StaticSafeArray<5, Lt>::set(i) = Lt(psTemp);
		}
	}
	friend pair<StringInput, W*> operator>>(const StringInput ps, W& rv) {
		return pair<StringInput, W*> (ps, &rv);
	}
	friend StringInput operator>>(pair<StringInput, W*> si_x, const char* psDlm) {
		if (si_x.first == NULL)
			return si_x.first;
		String s;
		StringInput si = si_x.first >> s >> psDlm;
		*si_x.second = s.c_array();
		return si;
	}
	bool operator==(const W& w) const {
		return DiscreteDomainRV<int, domainW>::operator==(w);
	}
	size_t getHashKey() const {
		return DiscreteDomainRV<int, domainW>::getHashKey();
	}
};

//// C: same as , since no role labels...
typedef Pos C;

////////////////////////////////////////////////////////////////////////////////
//
//  Models
//
////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////// "Wrapper" models for individual RVs...

class OpModel {
public:
	//HidVarCPT4DModel<OP,Syn,OP,Pos,LogProb> mOp_full;
	static HidVarCPT3DModel<OP, OP, Pos, LogProb> mOp_full;
	//const HidVarCPT1DModel<OP,LogProb> mOp_start; //Fixed Gen_ZERO model
	//static const HidVarCPT1DModel<OP,LogProb> mOp_BOT; //Fixed Op_ZERO model
public:
	LogProb setIterProb(OP::ArrayIterator<LogProb>& op, const OP & opP,
			const Pos & posP, int& a) const {
		LogProb pr, p;
		//cerr<<"mOp_full size in OpModel: "<<mOp_full.size()<<endl;
		//cerr << "   Before op model... op : "<<op<<" opP: "<<opP << " posP: "<<posP << pr<< endl;
		if(opP.getString()=="old" && posP.getString()=="-"){
			return LogProb();
		}

		pr = p = mOp_full.setIterProb(op, opP, posP, a);
		//cerr << " op: " << op << " opP: " << opP << " posP: " << posP << " a: "
			//			<< a << " pr: " << pr.toProb() << endl;
		// Report error...
		if (a < -2 && pr == LogProb())
			cerr << "\nERROR: no condition mOp_full op: " << op << " opP: "
			<< opP << " posP: " << posP << "\n\n";
		// Iterate again if result doesn't match root observation...
		//if ( a>=-1 ) pr=LogProb();
		////cerr<<"    F "<<d<<" "<<fD<<" "<<qP<<" "<<qU<<" : "<<f<<" = "<<pr<<" ("<<a<<")\n";
		return pr;
	}
	friend pair<StringInput, OpModel*> operator>>(StringInput si, OpModel& m) {
		return pair<StringInput, OpModel*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, OpModel*> si_m,
			const char* psD) {
		StringInput si;
		return ((si = si_m.first >> "Op " >> si_m.second->mOp_full >> psD)
				!= NULL) ? si : StringInput(NULL);
	}
};
HidVarCPT3DModel<OP, OP, Pos, LogProb> OpModel::mOp_full;;


class IndModel {
private:
	HidVarCPT3DModel<Loc, OP, Size, LogProb> mInd_Input;
	static HidVarCPT3DModel<Size, OP, Size, LogProb> mInd_Old;
	static HidVarCPT3DModel<Size, OP, Size, LogProb> mInd_New;
	static HidVarCPT3DModel<Size, OP, Size, LogProb> mInd_Copy;
	static HidVarCPT3DModel<Size, OP, Size, LogProb> mInd_End;
	static const HidVarCPT1DModel<Loc, LogProb> mInd_BOT; // Fixed Ind_ZERO model.
public:
	LogProb setIterProb(JointInd::ArrayIterator<LogProb>& jointInd,
			const OP & op, const JointInd & jointIndP, int& a) const {
		LogProb pr, p;
		if (op == Op_BOT) {
			//since mInd_BOT has setProb(Ind_BOT)=1.0, thus, its setIterProb will always
			//return 0 for any other values.
			pr = p = mInd_BOT.setIterProb(jointInd.first, a);
			if (!mInd_End.contains(op, jointIndP.second)) {
				mInd_End.setProb(Size_BOT, op, jointIndP.second) = 1.0;
			}
			pr *= p = mInd_End.setIterProb(jointInd.second, op,
					jointIndP.second, a);
		} else if (op == Op_OLD) {
			if(jointIndP.second==Size("1")){
				pr=p=mInd_BOT.setIterProb(jointInd.first,a);
				if (!mInd_Old.contains(op, jointIndP.second)) {
					mInd_Old.setProb(jointIndP.second, op, jointIndP.second) = 1.0;
				}
				pr*=p=mInd_Old.setIterProb(jointInd.second,op,jointIndP.second,a);
				if (a < -1 && p == LogProb())
					cerr << "\nERROR: no condition mInd_Input " << jointInd << " "
					<< op << " " << jointIndP << "\n\n";
				return pr;
			}
			if(Loc(jointInd.first)==Loc_BOT){
				pr=LogProb();
			}else{
				pr = p = mInd_Input.setIterProb(jointInd.first, op,
									jointIndP.second, a);
			}

			if (!mInd_Old.contains(op, jointIndP.second)) {
				mInd_Old.setProb(jointIndP.second, op, jointIndP.second) = 1.0;
			}
			pr *= p = mInd_Old.setIterProb(jointInd.second, op,
					jointIndP.second, a);
			if (a < -2 && p == LogProb())
				cerr << "\nERROR: no condition mInd_Input " << jointInd << " "
				<< op << " " << jointIndP << "\n\n";
		} else if (op == Op_NEW) {
			pr = p = mInd_BOT.setIterProb(jointInd.first, a);
			if (Size(jointInd.second) == Size_BOT) {
				int cur = 1;
				std::string s;
				std::stringstream out;
				out << cur;
				s = out.str();
				Size curSize = Size(s.c_str());
				if (!mInd_New.contains(op, jointIndP.second)) {
					mInd_New.setProb(curSize, op, jointIndP.second) = 1.0;
				}
				pr *= p = mInd_New.setIterProb(jointInd.second, op,
						jointIndP.second, a);
				//				cerr << " pr in ind: " << pr << " jointInd: " << jointInd
				//						<< " jointIndP: " << jointIndP << endl;
				return pr;
			}
			int size = atoi(jointIndP.second.getString().c_str());
			if (size < maxlen) {
				int cur = size + 1;
				std::string s;
				std::stringstream out;
				out << cur;
				s = out.str();
				Size curSize = Size(s.c_str());
				if (!mInd_New.contains(op, jointIndP.second)) {
					mInd_New.setProb(curSize, op, jointIndP.second) = 1.0;
				}
				//				pr*=p=mInd_New.setIterProb(jointInd.second,op,jointIndP.second,a);
			} else {
				std::string s;
				std::stringstream out;
				out << size;
				s = out.str();
				Size curSize = Size(s.c_str());
				if (!mInd_New.contains(op, jointIndP.second)) {
					mInd_New.setProb(curSize, op, jointIndP.second) = 1.0;
				}
				//				pr *= p = mInd_Old.setIterProb(jointInd.second, op, jointIndP.second, a);
			}
			pr *= p = mInd_New.setIterProb(jointInd.second, op,
					jointIndP.second, a);
			// tmill made this change!
		} else {
			//if op is copy
			pr = p = mInd_BOT.setIterProb(jointInd.first, a);
			//A lesson learned here, if we don't check contain, mInd_Copy will add the same
			//item repeatedly which will lead to infinite loop. It implies that simpleHash
			//doesn't have the function to sift out redundant items. dingcheng May 2, 10
			if(!mInd_Copy.contains(op,jointIndP.second)){
				mInd_Copy.setProb(jointIndP.second, op, jointIndP.second) = 1.0;
			}
			//			if(jointIndP.second==Size_BOT){
			//				//Size size=Size("1");
			//				mInd_Copy.setProb(jointIndP.second,op,jointIndP.second)=1.0;
			//			}
			//			else if(!mInd_Copy.contains(op,jointIndP.second)){
			//				int len = atoi(jointIndP.second.getString().c_str());
			//				if(len<maxlen){
			//					mInd_Copy.setProb(jointIndP.second,op,jointIndP.second)=1.0;
			//				}else{
			//					mInd_Copy.setProb(jointIndP.second,op,jointIndP.second)=1.0;
			//				}
			//
			//			}else{
			//				cerr << "ERROR: Should not be here! (d)" << endl;
			//			}
			pr *= p = mInd_Copy.setIterProb(jointInd.second, op,
					jointIndP.second, a);
		}
		//		cerr <<"a: "<<a<< " pr in ind: " << pr << " jointInd: " << jointInd
		//				<< " jointIndP: " << jointIndP << " op: " << op << endl;
		return pr;
	}
	friend pair<StringInput, IndModel*> operator>>(StringInput si, IndModel& m) {
		return pair<StringInput, IndModel*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, IndModel*> si_m,
			const char* psD) {
		StringInput si;
		return ((si = si_m.first >> "Ind " >> si_m.second->mInd_Input >> psD)
				!= NULL) ? si : StringInput(NULL);
	}
};
const HidVarCPT1DModel<Loc, LogProb> IndModel::mInd_BOT(Loc_BOT);
HidVarCPT3DModel<Size, OP, Size, LogProb> IndModel::mInd_Old;
HidVarCPT3DModel<Size, OP, Size, LogProb> IndModel::mInd_New;
HidVarCPT3DModel<Size, OP, Size, LogProb> IndModel::mInd_Copy;
HidVarCPT3DModel<Size, OP, Size, LogProb> IndModel::mInd_End;

class GenModel {
private:
	HidVarCPT2DModel<NewGen, NewGen, LogProb> mGen_Copy; //model when oper is COPY, then the probablity is 1
	static HidVarCPT3DModel<NewGen, OP, NewGen, LogProb> mGen_End;
	HidVarCPT2DModel<NewGen, OP, LogProb> mNewGen;
	static const HidVarCPT1DModel<NewGen, LogProb> mNewGen_BOT; //Fixed Gen_ZERO model
public:
	LogProb setIterProb(Gen::ArrayIterator<LogProb>& gen, const OP & op,
			const JointInd & jointInd, const Gen & genP, int& a) const {
		LogProb pr = LogProb(1.0);
		LogProb p;
		int loc = atoi(jointInd.first.getString().c_str());
		int size = atoi(jointInd.second.getString().c_str());
		if (op == Op_BOT) {
			for (unsigned int i = 0; i < maxlen; i++) {
				if (!mGen_End.contains(op, genP.get(i))) {
					mGen_End.setProb(NewGen_BOT, op, genP.get(i)) = 1.0;
				}
			}
			for (unsigned int i = 0; i < maxlen; i++) {
				pr *= p = mGen_End.setIterProb(gen.set(i), op, genP.get(i), a);
			}
		} else if (op == Op_COPY) {
			for (unsigned int i = 0; i < maxlen; i++) {
				//NewGen newGen = NewGen(gen.set(i)); const NewGen & newGenP = genP.get(i);
				pr *= p = mGen_Copy.setIterProb(gen.set(i), genP.get(i), a);
				//cerr<<" i: "<<i<<" a: "<<a<<" gen.set(i): "<<gen.set(i)<<" genP.get(i): "<<genP.get(i)<<" p inside: "<<p<<" pr: "<<pr<<endl;
			}
			//			cout << " pr: " << pr << " op is copy gen: " << gen
			//					<< " jointInd: " << jointInd << " genP " << genP << " a: "
			//					<< a << endl;
			if (a < -1 && p == LogProb())
				cerr << "\nERROR: no condition mGen_Copy " << gen << " " << op
				<< " " << jointInd << " " << genP << "\n\n";

		} else if (op == Op_NEW) {
			//genP.get(0)!=NewGen_BOT
			if (size < maxlen) {
				for (unsigned int i = 0; i < maxlen; i++) {
					if (i < size - 1) {
						pr *= p = mGen_Copy.setIterProb(gen.set(i),
								genP.get(i), a);
						//							cerr<<" i: "<<i<<" pr: "<<pr<<" gen.set(i): "<<gen.set(i)<<" mGen_Copy: "<<genP.get(i)<<" p: "<<p<<endl;
					} else if (i == size - 1) {
						pr *= p = mNewGen.setIterProb(gen.set(i), op, a);
						//							cerr<<" i: "<<i<<" pr: "<<pr<<" gen.set(i): "<<gen.set(i)<<" mGen_Copy: "<<genP.get(i)<<" p: "<<p<<endl;
					} else {
						pr *= p = mGen_Copy.setIterProb(gen.set(i),
								genP.get(i), a);
						//							cerr<<" i: "<<i<<" pr: "<<pr<<" gen.set(i): "<<gen.set(i)<<" mGen_Copy: "<<genP.get(i)<<" p: "<<p<<endl;
					}
				}
			} else if (size == maxlen) {

				if(genP.get(size-1)==NewGen_BOT){
					for (unsigned int i = 0; i < maxlen; i++) {
						if (i < maxlen - 1) {
							pr *= p = mGen_Copy.setIterProb(gen.set(i), genP.get(i), a);
						} else {
							pr *= p = mNewGen.setIterProb(gen.set(i), op, a);
						}
					}
				}else{
					for (unsigned int i = 0; i < maxlen; i++) {
						if (i < maxlen - 1) {
							pr *= p = mGen_Copy.setIterProb(gen.set(i), genP.get(i
									+ 1), a);
						} else {
							pr *= p = mNewGen.setIterProb(gen.set(i), op, a);
						}
					}
				}
			}
			//			cerr << " gen when op is new and genP is not Gen_BOT " << gen
			//					<< " p: " << p<<" pr: "<<pr << " op: " << op << " genP: " << genP
			//					<< endl;
			if (a < -1 && p == LogProb())
				cerr << "\nERROR: no condition mGen_New " << gen << " " << op
				<< " " << jointInd << " " << genP << "\n\n";
		} else {
			//if op is old
			if (size < maxlen) {
				for (unsigned int i = 0; i < maxlen; i++) {
					if (i < loc) {
						pr *= p = mGen_Copy.setIterProb(gen.set(i),
								genP.get(i), a);
					} else if (i < size - 1 && i >= loc) {
						pr *= p = mGen_Copy.setIterProb(gen.set(i), genP.get(i
								+ 1), a);
					} else if (i == size - 1) {
						pr *= p = mGen_Copy.setIterProb(gen.set(size - 1),
								genP.get(loc), a);
					} else if (i > size - 1) {
						pr *= p = mNewGen_BOT.setIterProb(gen.set(i), a);
					} else {
						cerr << "Should not be here! (z)" << endl;
					}
				}
			} else if (size == maxlen) {
				for (unsigned int i = 0; i < maxlen; i++) {
					if (i < loc) {
						pr *= p = mGen_Copy.setIterProb(gen.set(i),
								genP.get(i), a);
					} else if (i < size - 1 && i >= loc) {
						pr *= p = mGen_Copy.setIterProb(gen.set(i), genP.get(i
								+ 1), a);
					} else if (i == size - 1) {
						pr *= p = mGen_Copy.setIterProb(gen.set(size - 1),
								genP.get(loc), a);
					} else {
						cerr << "Should not be here! (e)" << endl;
					}
				}
			} else {
				cerr << "ERROR: Should not be here! (h)" << endl;
			}
			if (a < -1 && p == LogProb())
				cerr << "\nERROR: no condition mGen_Old " << gen << " " << op
				<< " " << loc << " " << genP << "\n\n";
		}
		// Report error...
		//if ( a<-1 && pr==LogProb() ) cerr<<"\nERROR: no condition mGen_full "<<" op: "<<op<<" genP: "<<genP<<"\n\n";
		// Iterate again if result doesn't match root observation...
		//if ( a>=-1 ) pr=LogProb();
		////cerr<<"    F "<<d<<" "<<fD<<" "<<qP<<" "<<qU<<" : "<<f<<" = "<<pr<<" ("<<a<<")\n";
		return pr;
	}
	friend pair<StringInput, GenModel*> operator>>(StringInput si, GenModel& m) {
		return pair<StringInput, GenModel*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, GenModel*> si_m,
			const char* psD) {
		StringInput si;
		return ((si = si_m.first >> "Gen " >> si_m.second->mNewGen >> psD)!= NULL ||
				(si = si_m.first >> "gencopy " >> si_m.second->mGen_Copy >> psD)!= NULL) ? si : StringInput(NULL);
	}
};

HidVarCPT3DModel<NewGen, OP, NewGen, LogProb> GenModel::mGen_End;
const HidVarCPT1DModel<NewGen, LogProb> GenModel::mNewGen_BOT(NewGen_BOT); //Fixed Gen_ZERO model

class NumModel {
private:
	HidVarCPT2DModel<NewNum, NewNum, LogProb> mNum_Copy; //model when oper is COPY, then the probablity is 1
	static HidVarCPT3DModel<NewNum, OP, NewNum, LogProb> mNum_End;
	HidVarCPT2DModel<NewNum, OP, LogProb> mNewNum;
	static const HidVarCPT1DModel<NewNum, LogProb> mNewNum_BOT; //Fixed Num_ZERO model
public:
	LogProb setIterProb(Num::ArrayIterator<LogProb>& num, const OP & op,
			const JointInd & jointInd, const Num & numP, int& a) const {
		LogProb pr = LogProb(1.0);
		LogProb p;
		int loc = atoi(jointInd.first.getString().c_str());
		int size = atoi(jointInd.second.getString().c_str());
		if (op == Op_BOT) {
			for (unsigned int i = 0; i < maxlen; i++) {
				if (!mNum_End.contains(op, numP.get(i))) {
					mNum_End.setProb(NewNum_BOT, op, numP.get(i)) = 1.0;
				}
			}
			for (unsigned int i = 0; i < maxlen; i++) {
				pr *= p = mNum_End.setIterProb(num.set(i), op, numP.get(i), a);
			}
		} else if (op == Op_COPY) {
			for (unsigned int i = 0; i < maxlen; i++) {
				pr *= p = mNum_Copy.setIterProb(num.set(i), numP.get(i), a);
			}
			//			cout << " pr: " << pr << " op is copy 2 Num: " << num
			//					<< " jointInd: " << jointInd << " numP " << numP << " a: "
			//					<< a << endl;
			if (a < -1 && p == LogProb())
				cerr << "\nERROR: no condition mNum_Copy " << num << " " << op
				<< " " << jointInd << " " << numP << "\n\n";

		} else if (op == Op_NEW) {
			if (size < maxlen) {
				for (unsigned int i = 0; i < maxlen; i++) {
					if (i != (size - 1)) {
						pr *= p = mNum_Copy.setIterProb(num.set(i),
								numP.get(i), a);
						//							cerr<<" i: "<<i<<" pr: "<<pr<<" num.set(i): "<<num.set(i)<<" mNum_Copy: "<<numP.get(i)<<" p: "<<p<<endl;
					} else if (i == size - 1) {
						pr *= p = mNewNum.setIterProb(num.set(i), op, a);
						//							cerr<<" i: "<<i<<" pr: "<<pr<<" num.set(i): "<<num.set(i)<<" mNum_Copy: "<<numP.get(i)<<" p: "<<p<<endl;
					} else {
						cerr << "should not be here (y)" << endl;
						//							cerr<<" i: "<<i<<" pr: "<<pr<<" num.set(i): "<<num.set(i)<<" mNum_Copy: "<<numP.get(i)<<" p: "<<p<<endl;
					}
				}
			} else if (size == maxlen) {
				if(numP.get(size-1)==NewNum_BOT){
					for (unsigned int i = 0; i < maxlen; i++) {
						if (i < maxlen - 1) {
							pr *= p = mNum_Copy.setIterProb(num.set(i), numP.get(i), a);
						} else {
							pr *= p = mNewNum.setIterProb(num.set(i), op, a);
						}
					}
				}else{
					for (unsigned int i = 0; i < maxlen; i++) {
						if (i < maxlen - 1) {
							pr *= p = mNum_Copy.setIterProb(num.set(i), numP.get(i
									+ 1), a);
						} else if (i == maxlen - 1) {
							pr *= p = mNewNum.setIterProb(num.set(i), op, a);
						} else {
							cerr << "Error: Should not be here! (gggg)" << endl;
						}
					}
				}

			} else {
				cerr << "ERROR: Should not be here! (g)" << endl;
			}
			//			cerr << " num when op is new and numP is not num_BOT " << num
			//					<< " p: " << p<<" pr: "<<pr  << " op: " << op << " numP: " << numP
			//					<< endl;
			if (a < -1 && p == LogProb())
				cerr << "\nERROR: no condition mNum_New " << num << " " << op
				<< " " << jointInd << " " << numP << "\n\n";
		} else {
			//when op==old
			if (size < maxlen) {
				for (unsigned int i = 0; i < maxlen; i++) {
					if (i < loc) {
						pr *= p = mNum_Copy.setIterProb(num.set(i),
								numP.get(i), a);
					} else if (i < size - 1 && i >= loc) {
						pr *= p = mNum_Copy.setIterProb(num.set(i), numP.get(i
								+ 1), a);
					} else if (i == size - 1) {
						pr *= p = mNum_Copy.setIterProb(num.set(size - 1),
								numP.get(loc), a);
					} else {
						pr *= p = mNewNum_BOT.setIterProb(num.set(i), a);
					}
				}

			} else if (size == maxlen) {
				for (unsigned int i = 0; i < maxlen; i++) {
					if (i < loc) {
						pr *= p = mNum_Copy.setIterProb(num.set(i),
								numP.get(i), a);
					} else if (i < size - 1 && i >= loc) {
						pr *= p = mNum_Copy.setIterProb(num.set(i), numP.get(i
								+ 1), a);
					} else if (i == size - 1) {
						pr *= p = mNum_Copy.setIterProb(num.set(size - 1),
								numP.get(loc), a);
					} else {
						cerr << "Error: Should not be here! (g)" << endl;
					}
				}
			}
			if (a < -1 && p == LogProb())
				cerr << "\nERROR: no condition mNum_Old " << num << " " << op
				<< " " << loc << " " << numP << "\n\n";
		}
		// Report error...
		//if ( a<-1 && pr==LogProb() ) cerr<<"\nERROR: no condition mNum_full "<<" op: "<<op<<" numP: "<<numP<<"\n\n";
		// Iterate again if result doesn't match root observation...
		//if ( a>=-1 ) pr=LogProb();
		////cerr<<"    F "<<d<<" "<<fD<<" "<<qP<<" "<<qU<<" : "<<f<<" = "<<pr<<" ("<<a<<")\n";
		return pr;
	}
	friend pair<StringInput, NumModel*> operator>>(StringInput si, NumModel& m) {
		return pair<StringInput, NumModel*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, NumModel*> si_m,
			const char* psD) {
		StringInput si;
		return ((si = si_m.first >> "Num " >> si_m.second->mNewNum >> psD) != NULL ||
				(si = si_m.first >> "numcopy " >> si_m.second->mNum_Copy >> psD) != NULL) ? si : StringInput(NULL);
	}
};

HidVarCPT3DModel<NewNum, OP, NewNum, LogProb> NumModel::mNum_End;
const HidVarCPT1DModel<NewNum, LogProb> NumModel::mNewNum_BOT(NewNum_BOT); //Fixed Num_ZERO model

class SynModel {
private:
	HidVarCPT2DModel<NewSyn, NewSyn, LogProb> mSyn_Copy; //model when oper is COPY, then the probablity is 1
	static HidVarCPT3DModel<NewSyn, OP, NewSyn, LogProb> mSyn_End;
	HidVarCPT2DModel<NewSyn, OP, LogProb> mNewSyn;
	static const HidVarCPT1DModel<NewSyn, LogProb> mNewSyn_BOT; //Fixed Syn_ZERO model
public:
	LogProb setIterProb(Syn::ArrayIterator<LogProb>& syn, const OP & op, const JointInd & jointInd, const Syn & synP, int& a) const {
		LogProb pr = LogProb(1.0);
		LogProb p;
		int loc = atoi(jointInd.first.getString().c_str());
		int size = atoi(jointInd.second.getString().c_str());
		if (op == Op_BOT) {
			for (unsigned int i = 0; i < maxlen; i++) {
				if (!mSyn_End.contains(op, synP.get(i))) {
					mSyn_End.setProb(NewSyn_BOT, op, synP.get(i)) = 1.0;
				}
			}
			for (unsigned int i = 0; i < maxlen; i++) {
				pr *= p = mSyn_End.setIterProb(syn.set(i), op, synP.get(i), a);
			}

			//cerr << "\nin mSyn_End syn: " << syn << " jointInd : " << jointInd << " synP " << synP << " op: " << op << " a: " << a << " pr: " << pr << endl;
		} else if (op == Op_COPY) {
			for (unsigned int i = 0; i < maxlen; i++) {
				pr *= p = mSyn_Copy.setIterProb(syn.set(i), synP.get(i), a);
			}
			//cerr << " pr: " << pr << " op is copy 2 Syn: " << syn << " jointInd: " << jointInd << " synP " << synP << " a: " << a << endl;
			if (a < -1 && p == LogProb())
				cerr << "\nERROR: no condition mSyn_Copy " << syn << " " << op << " " << jointInd << " " << synP << "\n\n";

		} else if (op == Op_NEW) {
			if (size < maxlen) {
				for (unsigned int i = 0; i < maxlen; i++) {
					if (i != (size - 1)) {
						pr *= p = mSyn_Copy.setIterProb(syn.set(i), synP.get(i), a);
						//							cerr<<" i: "<<i<<" pr: "<<pr<<" syn.set(i): "<<syn.set(i)<<" mSyn_Copy: "<<synP.get(i)<<" p: "<<p<<endl;
					} else if (i == size - 1) {
						pr *= p = mNewSyn.setIterProb(syn.set(i), op, a);
						//							cerr<<" i: "<<i<<" pr: "<<pr<<" syn.set(i): "<<syn.set(i)<<" mSyn_Copy: "<<synP.get(i)<<" p: "<<p<<endl;
					} else {
						cerr << "should not be here (y)" << endl;
						//							cerr<<" i: "<<i<<" pr: "<<pr<<" syn.set(i): "<<syn.set(i)<<" mSyn_Copy: "<<synP.get(i)<<" p: "<<p<<endl;
					}
				}
				//cerr << "\nin mSyn_New and size is smaller than maxlen syn: " << syn << " jointInd : " << jointInd << " synP " << synP << " op: " << op << " a: " << a << " pr: " << pr << endl;
			} else if (size == maxlen) {
				if (synP.get(size - 1) == NewSyn_BOT) {
					for (unsigned int i = 0; i < maxlen; i++) {
						if (i < maxlen - 1) {
							pr *= p = mSyn_Copy.setIterProb(syn.set(i), synP.get(i), a);
						} else {
							pr *= p = mNewSyn.setIterProb(syn.set(i), op, a);
						}
					}
				} else {
					for (unsigned int i = 0; i < maxlen; i++) {
						if (i < maxlen - 1) {
							pr *= p = mSyn_Copy.setIterProb(syn.set(i), synP.get(i + 1), a);
						} else if (i == maxlen - 1) {
							pr *= p = mNewSyn.setIterProb(syn.set(i), op, a);
						} else {
							cerr << "Error: Should not be here! (gggg)" << endl;
						}
					}
				}
				//cerr << "\nin mSyn_New and size is equal maxlen syn: " << syn << " jointInd : " << jointInd << " synP " << synP << " op: " << op << " a: " << a << " pr: " << pr << endl;
			} else {
				cerr << "ERROR: Should not be here! (g)" << endl;
			}
			//			cerr << " syn when op is new and synP is not syn_BOT " << syn
			//					<< " p: " << p<<" pr: "<<pr  << " op: " << op << " synP: " << synP
			//					<< endl;
			if (a < -1 && p == LogProb())
				cerr << "\nERROR: no condition mSyn_New " << syn << " " << op << " " << jointInd << " " << synP << "\n\n";
		} else {
			//when op==old
			if (size < maxlen) {
				for (unsigned int i = 0; i < maxlen; i++) {
					if (i < loc) {
						pr *= p = mSyn_Copy.setIterProb(syn.set(i), synP.get(i), a);
					} else if (i < size - 1 && i >= loc) {
						pr *= p = mSyn_Copy.setIterProb(syn.set(i), synP.get(i + 1), a);
					} else if (i == size - 1) {
						pr *= p = mSyn_Copy.setIterProb(syn.set(size - 1), synP.get(loc), a);
					} else {
						pr *= p = mNewSyn_BOT.setIterProb(syn.set(i), a);
					}
				}
				//cerr << "\nin mSyn_Old and size is smaller than maxlen syn: " << syn << " jointInd : " << jointInd << " synP " << synP << " op: " << op << " a: " << a << " pr: " << pr << endl;
			} else if (size == maxlen) {
				for (unsigned int i = 0; i < maxlen; i++) {
					if (i < loc) {
						pr *= p = mSyn_Copy.setIterProb(syn.set(i), synP.get(i), a);
					} else if (i < size - 1 && i >= loc) {
						pr *= p = mSyn_Copy.setIterProb(syn.set(i), synP.get(i + 1), a);
					} else if (i == size - 1) {
						pr *= p = mSyn_Copy.setIterProb(syn.set(size - 1), synP.get(loc), a);
					} else {
						cerr << "Error: Should not be here! (g)" << endl;
					}
				}
				//cerr << "\nin mSyn_New and size is equal to maxlen syn: " << syn << " jointInd : " << jointInd << " synP " << synP << " op: " << op << " a: " << a << " pr: " << pr << endl;
			}
			if (a < -1 && p == LogProb())
				cerr << "\nERROR: no condition mSyn_Old " << syn << " " << op << " " << loc << " " << synP << "\n\n";
		}
		// Report error...
		//if ( a<-1 && pr==LogProb() ) cerr<<"\nERROR: no condition mSyn_full "<<" op: "<<op<<" synP: "<<synP<<"\n\n";
		// Iterate again if result doesn't match root observation...
		//if ( a>=-1 ) pr=LogProb();
		////cerr<<"    F "<<d<<" "<<fD<<" "<<qP<<" "<<qU<<" : "<<f<<" = "<<pr<<" ("<<a<<")\n";
		return pr;
	}
	friend pair<StringInput, SynModel*> operator>>(StringInput si, SynModel& m) {
		return pair<StringInput, SynModel*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, SynModel*> si_m, const char* psD) {
		StringInput si;
		return ((si = si_m.first >> "Ne " >> si_m.second->mNewSyn >> psD) != NULL || (si = si_m.first >> "necopy " >> si_m.second->mSyn_Copy >> psD) != NULL) ? si : StringInput(NULL);
	}
};

HidVarCPT3DModel<NewSyn, OP, NewSyn, LogProb> SynModel::mSyn_End;
const HidVarCPT1DModel<NewSyn, LogProb> SynModel::mNewSyn_BOT(NewSyn_BOT); //Fixed Syn_ZERO model



class SynOldModel {
private:
	HidVarCPT2DModel<NewSyn, NewSyn, LogProb> mSyn_Copy; //model when oper is COPY, then the probablity is 1
	static HidVarCPT3DModel<NewSyn, OP, NewSyn, LogProb> mSyn_End;
	HidVarCPT2DModel<NewSyn, OP, LogProb> mNewSyn;
	//HidVarCPT2DModel<NewSyn, OP, LogProb> mOldSyn;
	static const HidVarCPT1DModel<NewSyn, LogProb> mNewSyn_BOT; //Fixed Syn_ZERO model
public:
	LogProb setIterProb(Syn::ArrayIterator<LogProb>& syn, const OP & op,
			const JointInd & jointInd, const Syn & synP, int& a) const {
		LogProb pr = LogProb(1.0);
		LogProb p;
		int loc = atoi(jointInd.first.getString().c_str());
		int size = atoi(jointInd.second.getString().c_str());
		if (op == Op_BOT) {
			for (unsigned int i = 0; i < maxlen; i++) {
				if (!mSyn_End.contains(op, synP.get(i))) {
					mSyn_End.setProb(NewSyn_BOT, op, synP.get(i)) = 1.0;
				}
			}
			for (unsigned int i = 0; i < maxlen; i++) {
				pr *= p = mSyn_End.setIterProb(syn.set(i), op, synP.get(i), a);
			}
		} else if (op == Op_COPY) {
			for (unsigned int i = 0; i < maxlen; i++) {
				pr *= p = mSyn_Copy.setIterProb(syn.set(i), synP.get(i), a);
			}
			//			cout << " pr: " << pr << " op is copy 2 Syn: " << syn
			//					<< " jointInd: " << jointInd << " synP " << synP << " a: "
			//					<< a << endl;
			if (a < -1 && p == LogProb())
				cerr << "\nERROR: no condition mSyn_Copy " << syn << " " << op
				<< " " << jointInd << " " << synP << "\n\n";

		} else if (op == Op_NEW) {
			if (size < maxlen) {
				for (unsigned int i = 0; i < maxlen; i++) {
					if (i != size - 1) {
						pr *= p = mSyn_Copy.setIterProb(syn.set(i),
								synP.get(i), a);
						//							cerr<<" i: "<<i<<" pr: "<<pr<<" syn.set(i): "<<syn.set(i)<<" mSyn_Copy: "<<synP.get(i)<<" p: "<<p<<endl;
					} else if (i == size - 1) {
						pr *= p = mNewSyn.setIterProb(syn.set(i), op, a);
						//							cerr<<" i: "<<i<<" pr: "<<pr<<" syn.set(i): "<<syn.set(i)<<" mSyn_Copy: "<<synP.get(i)<<" p: "<<p<<endl;
						if (a < -1 && p == LogProb())
							cerr << "\nERROR: no condition mSyn_New " << syn << " " << op
							<< " " << jointInd << " " << synP << "\n\n";
					} else {
						cerr << "Error: Should not be here! (gsynew)" << endl;
					}
				}

			} else if (size == maxlen) {
				if(synP.get(size-1)==NewSyn_BOT){
					for (unsigned int i = 0; i < maxlen; i++) {
						if (i < maxlen - 1) {
							pr *= p = mSyn_Copy.setIterProb(syn.set(i), synP.get(i), a);
						} else if (i == maxlen - 1) {
							pr *= p = mNewSyn.setIterProb(syn.set(i), op, a);
							if (a < -1 && p == LogProb())
								cerr << "\nERROR: no condition mSyn_New " << syn << " " << op
								<< " " << jointInd << " " << synP << "\n\n";
						} else {
							cerr << "Error: Should not be here! (gsynew3)" << endl;
						}
					}
				}else{
					for (unsigned int i = 0; i < maxlen; i++) {
						if (i < maxlen - 1) {
							pr *= p = mSyn_Copy.setIterProb(syn.set(i), synP.get(i
									+ 1), a);
						} else if (i == maxlen - 1) {
							pr *= p = mNewSyn.setIterProb(syn.set(i), op, a);
							if (a < -1 && p == LogProb())
								cerr << "\nERROR: no condition mSyn_New " << syn << " " << op
								<< " " << jointInd << " " << synP << "\n\n";
						} else {
							cerr << "Error: Should not be here! (gsynew3)" << endl;
						}
					}
				}

			} else {
				cerr << "Should not be here!(gsynew4) " << endl;
			}
			//			cerr << " syn when op is new and synP is not syn_BOT " << syn
			//					<< " p: " << p <<" pr: "<<pr<< " op: " << op << " synP: " << synP
			//					<< endl;
			if (a < -1 && p == LogProb())
				cerr << "\nERROR: no condition mSyn_New " << syn << " " << op
				<< " " << jointInd << " " << synP << "\n\n";

		} else {
			//when op is old
			if (size < maxlen) {
				for (unsigned int i = 0; i < maxlen; i++) {
					if (i < loc || i>=size	) {
						pr *= p = mSyn_Copy.setIterProb(syn.set(i),synP.get(i), a);
						//cerr<<" i: "<<i<<" syn.set(i): "<<syn.set(i)<<" synP.get(i): "<<synP.get(i)<<endl;
					} else if (i < size - 1 && i >= loc) {
						pr *= p = mSyn_Copy.setIterProb(syn.set(i), synP.get(i + 1), a);
						//cerr<<" i: "<<i<<" syn.set(i): "<<syn.set(i)<<" synP.get(i): "<<synP.get(i)<<" synP.get(i+1): "<<synP.get(i+1)<<endl;
					} else if (i == size - 1) {
						if(size==1){
							pr*=p=mNewSyn_BOT.setIterProb(syn.set(i),a);
						}else{
							pr *= p = mNewSyn.setIterProb(syn.set(i), op, a);
							//cerr<<" i: "<<i<<" syn.set(i): "<<syn.set(i)<<" synP.get(i): "<<synP.get(i)<<endl;
						}

						if (a < -1 && p == LogProb())
							cerr << "\nERROR: no condition mSyn_Old syn: " << syn << " op: " << op
							<< " loc: " << loc << " size: " << size << " synP: " << synP << "\n\n";
					}
					//					else {
					//						pr *= p = mNewSyn_BOT.setIterProb(syn.set(i), a);
					//					}
				}

			} else if (size == maxlen) {
				for (unsigned int i = 0; i < maxlen; i++) {
					if (i < loc) {
						pr *= p = mSyn_Copy.setIterProb(syn.set(i),
								synP.get(i), a);
					} else if (i < size - 1 && i >= loc) {
						pr *= p = mSyn_Copy.setIterProb(syn.set(i), synP.get(i
								+ 1), a);
					} else if (i == size - 1) {
						if(size==1){
							pr*=p=mNewSyn_BOT.setIterProb(syn.set(i),a);
							//return pr;
						}else{
							pr *= p = mNewSyn.setIterProb(syn.set(size - 1), op, a);
						}
						if (a < -1 && p == LogProb())
							cerr << "\nERROR: no condition mSyn_Old " << syn << " " << op
							<< " loc: " << loc << " size: " << size<< " synP " << synP << "\n\n";
					} else {
						cerr << "Error!  Should not be here! (a)" << endl;
					}
				}
			}
			if (a < -1 && p == LogProb())
				cerr << "\nERROR: no condition mSyn_Old " << syn << " " << op
				<< " " << loc << " " << synP << "\n\n";
		}
		// Report error...
		//if ( a<-1 && pr==LogProb() ) cerr<<"\nERROR: no condition mSyn_full "<<" op: "<<op<<" synP: "<<synP<<"\n\n";
		// Iterate again if result doesn't match root observation...
		//if ( a>=-1 ) pr=LogProb();
		////cerr<<"    F "<<d<<" "<<fD<<" "<<qP<<" "<<qU<<" : "<<f<<" = "<<pr<<" ("<<a<<")\n";
		return pr;
	}
	friend pair<StringInput, SynOldModel*> operator>>(StringInput si, SynOldModel& m) {
		return pair<StringInput, SynOldModel*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, SynOldModel*> si_m,
			const char* psD) {
		StringInput si;
		return ((si = si_m.first >> "Ne " >> si_m.second->mNewSyn >> psD)!= NULL ||
				(si = si_m.first >> "necopy " >> si_m.second->mSyn_Copy >> psD)!= NULL) ? si : StringInput(NULL);
		//return ((si = si_m.first >> "Syn " >> si_m.second->mNewSyn >> psD)!= NULL ||
				//(si = si_m.first >> "syncopy " >> si_m.second->mSyn_Copy >> psD)!= NULL) ? si : StringInput(NULL);
	}
};
HidVarCPT3DModel<NewSyn, OP, NewSyn, LogProb> SynOldModel::mSyn_End;
const HidVarCPT1DModel<NewSyn, LogProb> SynOldModel::mNewSyn_BOT(NewSyn_BOT); //Fixed Syn_ZERO model

class PosModel {
private:
	//static HidVarCPT3DModel<Pos,OP,Pos,LogProb> mPos_Copy;
	//HidVarCPT3DModel<Pos, OP, Pos, LogProb> mPos_full;
	HidVarCPT3DModel<Pos, Pos,  OP, LogProb> mPos_full;
	//	static const HidVarCPT1DModel<Pos,LogProb> mPos_BOT; //Fixed Pos_ZERO model
public:
	LogProb setIterProb(Pos::ArrayIterator<LogProb>& pos,
			const Pos & posP, const OP & op,int& a) const {
		LogProb pr, p;
		//		if(posP==Pos_BOT){
		//			pr=p=mPos_BOT.setIterProb(pos,a);
		//
		//		}else{
		pr = p = mPos_full.setIterProb(pos, posP, op, a);
		if(pr==LogProb()){
			return pr;
		}
		//cerr << "posP: " << posP << " pos: " << pos << " pr: " << pr.toProb() << endl;
				//}
		// Report error...
		if (a < -1 && pr == LogProb())
			cerr << "\nERROR: no condition mPos_full " << " pos: " << Pos(pos)
			<< " posP: " << posP << " op: " << op << "\n\n";
		// Iterate again if result doesn't match root observation...
		//if ( a>=-1 ) pr=LogProb();
		////cerr<<"    F "<<d<<" "<<fD<<" "<<qP<<" "<<qU<<" : "<<f<<" = "<<pr<<" ("<<a<<")\n";
		return pr;
	}
	friend pair<StringInput, PosModel*> operator>>(StringInput si, PosModel& m) {
		return pair<StringInput, PosModel*> (si, &m);
	}
	friend StringInput operator>>(pair<StringInput, PosModel*> si_m,
			const char* psD) {
		StringInput si;
		return ((si = si_m.first >> "Pos " >> si_m.second->mPos_full >> psD)
				!= NULL) ? si : StringInput(NULL);
	}
};
//HidVarCPT3DModel<Pos,OP, Pos,LogProb> PosModel::mPos_Copy;
//const HidVarCPT1DModel<Pos,LogProb> PosModel::mPos_BOT(Pos_BOT); //Fixed Pos_ZERO model

//////Model of Cr 
class CrModel: public QuadrupleFactoredModel<IndModel, GenModel, NumModel,
SynModel> {
public:
	LogProb setIterProb(CR::ArrayIterator<LogProb>& cr, const OP & op,
			const CR& crP, int& a) const {
		const IndModel& mInd = getM1();
		const GenModel& mGen = getM2();
		const NumModel& mNum = getM3();
		const SynModel& mSyn = getM4();
		LogProb pr;
		//int old_a = a;
		pr = mInd.setIterProb(cr.first, op, crP.first, a);
		if(pr==LogProb()){
			return pr;
		}
//		if (!((old_a - a) == 2))
//			cerr << "ERROR: a has wrong value in mInd! " << a << " old_a-a: "
//			<< old_a - a << endl;
//		old_a = a;
		//pr = (crP.first.first == Ind_BOT && op == Op_COPY)?
		//mInd_BOT.setIterProb(cr.first.first,a): mInd.setIterProb (cr.first, op, crP.first, a );
		//if ( LogProb()==pr ) return pr;
		CR().setVal(cr);
		JointInd().setVal(cr.first);
		pr *= mGen.setIterProb(cr.second, op, JointInd(cr.first.first,
				cr.first.second), crP.second, a);
		if(pr==LogProb()){
			return pr;
		}
//		if (!((old_a - a) == 6))
//			cerr << "ERROR: a has wrong value in mGen! " << a << " old_a-a: "
//			<< old_a - a << endl;
//		old_a = a;
		pr *= mNum.setIterProb(cr.third, op, JointInd(cr.first.first,
				cr.first.second), crP.third, a);
		if(pr==LogProb()){
			return pr;
		}
//		if (!((old_a - a) == 6))
//			cerr << "ERROR: a has wrong value in mNum! " << a << " old_a-a: "
//			<< old_a - a << endl;
//		old_a = a;
		pr *= mSyn.setIterProb(cr.fourth, op, JointInd(cr.first.first,
				cr.first.second), crP.fourth, a);
//		if (!((old_a - a) == 6))
//			cerr << "ERROR: a has wrong value in mSyn! " << a << " old_a-a: "
//			<< old_a - a << endl;
//		old_a = a;
		return pr;
	}
};

//class RModel{
//	LogProb setIterProb( R::ArrayIterator < LogProb > & r, const R rP, int & a){
//		const FModel& mF = getM1();
//		LogProb pr;
//		return pr;
//		}
//};


class SModel: public TripleFactoredModel<OpModel, CrModel, PosModel> {
public:
	LogProb setIterProb(S::ArrayIterator<LogProb>& s, const S& sP, int& a) const {
		const OpModel& mOp = getM1();
		const CrModel& mCr = getM2();
		const PosModel& mPos = getM3();
		LogProb pr;
		//int old_a = a;
		//cerr<<" a starts in SModel:"<<a<<endl;
		pr = mOp.setIterProb(s.first, sP.first, sP.second.second, a);
		if(pr==LogProb()){
			return pr;
		}
//		if (((old_a - a) != 1))
//			cerr << "ERROR: a has wrong value in mOP!" << a << " a-old_a: "
//			<< old_a - a << endl;
//		old_a = a;
		//the following works since s.first returns a DilimitedJoint2DRV CR which is composed of
		//Ind and Syn. That is right what CRModel's setIterProb is looking for
		//pr = (sP.first != Op_BOT)? mOp.setIterProb ( s.first, sP.first, sP.second.first, sP.second.second, a )
		//:mOp_BOT.setIterProb(s.first,a);
		pr *= mCr.setIterProb(s.second.first, OP(s.first), CR(sP.second.first),
				a);
		if(pr==LogProb()){
			return pr;
		}
//		if (!((old_a - a) == 20))
//			cerr << "ERROR: a has wrong value in mCR! old_a: "<<old_a<< " a : " << a << " old_a-a: "
//			<< old_a - a << endl;
//		old_a = a;
		//if ( LogProb()==pr ) return pr;
		//cout<<"pr, before mPos if op is copy, should be the same, right????????????????????? :"<<pr<<endl;
		pr *= mPos.setIterProb(s.second.second, Pos(
				sP.second.second),OP(s.first),  a);
		if(pr==LogProb()){
			return pr;
		}
//		if (!((old_a - a) == 1))
//			cerr << "ERROR: a has wrong value in mPos! old_a: "<<old_a<< " a : " << a << " a-old_a: "
//			<< old_a - a << endl;
//		old_a = a;
		//cout<<"pr at the end of Smodel "<<pr<<endl;
		return pr;
	}
};

//
//
////////////////////// Overall...
//
////// Model of H=R,S given S
class HModel: public SingleFactoredModel<SModel> {
public:
	static W WORD;
	typedef H::ArrayIterator<LogProb> IterVal;
	S& setTrellDat(S& s, const H::ArrayIterator<LogProb>& h) const {
		//h.setVal(h.second);
		s.setVal(h);
		return s;
	}
	S setBackDat(const H::ArrayIterator<LogProb>& h) const {
		//R r;
		S s;
		//for(int i=0;i<4;i++)
		//r.set(i)=F(h.first.get(i));
		s.setVal(h);
		return s;
	}
	LogProb setIterProb(H::ArrayIterator<LogProb>& h, const S & sP, int& a) const {
		//const RModel& mR = getM1();
		const SModel& mS = getM1();
		LogProb pr;
		//pr  = mR.setIterProb ( h.first, sP, a );
		//pr  = mR.setIterProb ( h.first, sP, a );
		//if ( LogProb()==pr ) return pr;
		pr = mS.setIterProb(h, sP, a);
		if(pr==LogProb()){
			return pr;
		}
		//		cout << " h = " << h << " sP: " << sP << " pr: " << pr
		//				<< " and a ends in HModel = " << a << endl;
		return pr;
	}
	void update() const {
	}
};
W HModel::WORD;

