///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

package edu.umn.cs.nlp.textproc;

import java.io.*;
import java.util.*;

public class AnnotatedGrammar {

	public static int[] counts = new int[10000000];
    public static int counter = 0;
    public static FileWriter file_rules;
    public static Scanner userinput = new Scanner(System.in);
    
	/**
	 * @param args
	 */
	
	@SuppressWarnings("unchecked")
	public static void main(String[] args) throws IOException{
		
		String conline;
	    FileWriter file_summary;
		
		//System.out.print("Enter the File rules with its path");
		file_rules = new FileWriter(args[0]);
		
    	        //System.out.print("Enter the Input Directory");
	  	conline = args[1];
    
        
        //System.out.print("Enter the Output Report Name with its directory");
        file_summary = new FileWriter(args[2]);
         	
       	File dir= new File(conline);
       	File [] fi = dir.listFiles();
     	for (int k=0;k<fi.length;k++)
     	{
     		int i=1;
        	File reader_f=new File(conline+fi[k].getName());
            System.out.println(conline+fi[k].getName()+"\n");
        
        	Scanner s_f= new Scanner(reader_f);
        	String substring, basestatement= s_f.nextLine();
        	char [] statement = basestatement.toCharArray();

        	Queue q= new LinkedList();
       		q.add(statement[0]); q.add(1);
        	while (i<statement.length)
        	{
        		 if ((statement[i] == '(') || (statement[i] == ')'))
        			 q.add(statement[i]);
                 else
                	 if (statement[i] == ' ')
                		 q.add(statement[i]);
                	 else
                	 {
                		 substring = "";
                		 while ((statement[i] != '(') && (statement[i] != ')'))
                		 {
                			 substring += statement[i];
                			 i++;
                		 }
                		 q.add(substring);
                		 q.add(statement[i]);
                	  }
        		 i++;
            }
        	ret_stack(q, q.size());
        	
        	int max = 1;
        	for (int i1 = 0; i1 < counts.length; i1++)
        		if (counts[i1] != 0)
        		{
        			if (max < counts[i1])
        				max = counts[i1];
        		}
        	for (int i1 = 0; i1 < counts.length; i1++)
        		counts[i1] = 0;
            file_summary.append("p("+conline+fi[k].getName()+ " ) = "+ max+"\n");     
        }
     	file_summary.close();
        file_rules.close();
    }
	@SuppressWarnings("unchecked")
	private static void ret_stack(Queue q, int size) throws IOException{
		Queue root = new LinkedList();
        Queue lCh_Temp = new LinkedList();
        Queue lCh = new LinkedList();
        Queue rCh_Temp = new LinkedList();
        Queue rCh = new LinkedList();
        Stack s = new Stack();
        
        String statement = "", statementRoot = "", statementRight = "", statementLeft = "", statementRight2 = "", statementLeft2 = "";
        String [] subtree = new String[2];
        
        Object o,o1,o2,o3;
	   
        if (size > 4)
        {
            String x = q.remove().toString();
            int lCh_Count =0, rCh_Count = 0, s_Count = 0;
         
            root.add(x);    o = q.remove();
            int level = (Integer)o; root.add(level);

            o1 = q.remove();      root.add(o1);

            statementRoot = "("+o1.toString().trim() + ")"+ "^"+ level;
             
            while (lCh_Count < size)
            {
                lCh_Count++;
                if ((q.element().equals('(')) || (q.element().equals(')')))
                {
                    if (q.element().equals('(')) { s.push('('); s_Count++; }
                    if (q.element().equals(')')) { s.pop(); s_Count--; }
                    lCh_Temp.add(q.remove());
                    if (s_Count == 0) break;
                }
                else
                    lCh_Temp.add(q.remove());
            }
            
            lCh.add(lCh_Temp.remove()); lCh.add(level); 
            o2 = lCh_Temp.remove(); lCh.add(o2);
             
            if (!(o2.toString().trim().indexOf(' ')== -1))
            {
            	 
                subtree = o2.toString().trim().split(" ");
                statementLeft = "(" + subtree[0].trim() + ")";
                statementLeft2 = "("+ subtree[0].trim() + ")"+" " + "("+subtree[1].trim()+")";
            }
            else
                statementLeft = "(" + o2.toString().trim() + ")" + "^" + level;

            for (int k = 2; k < lCh_Count; k++)
                lCh.add(lCh_Temp.remove());
            
            for (int j = lCh_Count+3; j < size-1; j++)
            {
              
                if (!(q.element().equals(' ')))
                {
                        rCh_Count++;
                        rCh_Temp.add(q.remove());
                }
                    else
                        q.remove();                   
            }
        	 
            if (!(rCh_Temp.isEmpty()))
            {
            	
                rCh.add(rCh_Temp.remove()); rCh.add(level + 1);
             
                o3= rCh_Temp.remove();    rCh.add(o3);
              
                int l = level + 1; 
                
                for (int k = 2; k < rCh_Count; k++)
                    rCh.add(rCh_Temp.remove());
                
              
                if (!(o3.toString().trim().indexOf(' ')==-1))
                {
                    subtree = o3.toString().trim().split(" ");
                    statementRight = "(" + subtree[0].trim() + ")";
                    statementRight2 = "(" + subtree[0].trim() + ")" + " " + "(" + subtree[1].trim() + ")";
                }
                else
                    statementRight = "(" + o3.toString().trim() + ")" + "^" + l;
                rCh_Count++;
            }

            lCh_Count++;

            statement = statementRoot.trim() + " " + statementLeft.trim();
            
            if (statementRight != "")
               statement += " " + statementRight.trim();
                          
            file_rules.write(statement+'\n');
             
            if (statementLeft2 != "")
               file_rules.write(statementLeft2+'\n');
            
            if (statementRight2 != "")
               file_rules.write(statementRight2+'\n');
               
            counts[counter] = level;       counter++;
            
            ret_stack(lCh, lCh_Count);
            ret_stack(rCh, rCh_Count);
              
      }
   
	}
}











        	
 

