///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>

#include "nl-iomacros.h"
#include "nl-cpt.h"

///////////////////////////////////////////////////////////////////////////////


//////////

char psX[]="";
char psComma[]=",";
char psColon[]=":";
char psSpace[]=" ";
char psLBrace[]="{";
char psRBrace[]="}";


//////////

DiscreteDomain<int> domU;
typedef DiscreteDomainRV<int,domU> U;
const U U_L("l");
const U U_R("r");

DiscreteDomain<int> domD;
typedef DiscreteDomainRV<int,domD> D;
const D D_0("0");
const D D_1("1");
const D D_2("2");
const D D_3("3");
const D D_4("4");
const D D_5("5");

DiscreteDomain<int> domL;
typedef DiscreteDomainRV<int,domL> L;

DiscreteDomain<int> domI;
typedef DiscreteDomainRV<int,domI> I;

DiscreteDomain<int> domH;
typedef DiscreteDomainRV<int,domH> H;


//// B: boolean
DiscreteDomain<char> domB;
//typedef DiscreteDomainRV<char,domB> B;
class B : public DiscreteDomainRV<char,domB> {
 public:
  B ( )                : DiscreteDomainRV<char,domB> ( )    { }
  B ( const char* ps ) : DiscreteDomainRV<char,domB> ( ps ) { }
};
const B B_0 ("0");
const B B_1 ("1");


//// C: constituent category...
DiscreteDomain<int> domC;
//typedef DiscreteDomainRV<int,domC> C;
class C : public DiscreteDomainRV<int,domC> {
 private:
  static SimpleHash<C,B> hToTerm;
  void calcDetModels ( string s ) {
    if (!hToTerm.contains(*this)) {
      hToTerm.set(*this) = (('A'<=s[0] && s[0]<='Z') || s.find('_')!=string::npos) ? B_0 : B_1;
    }
  }
 public:
  C ( )                : DiscreteDomainRV<int,domC> ( )    { }
  C ( const DiscreteDomainRV<int,domC>& rv ) : DiscreteDomainRV<int,domC>(rv) { }
  C ( const char* ps ) : DiscreteDomainRV<int,domC> ( ps ) { calcDetModels(ps); }
  //C ( string s ) : DiscreteDomainRV<int,domC> ( s )  { calcDetModels(s); }
  B getTerm ( ) const { return hToTerm.get(*this); }
  friend pair<StringInput,C*> operator>> ( StringInput si, C& m ) { return pair<StringInput,C*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,C*> si_m, const char* psD ) {
    if ( si_m.first == NULL ) return NULL;
    StringInput si=si_m.first>>(DiscreteDomainRV<int,domC>&)*si_m.second>>psD;
    si_m.second->calcDetModels(si_m.second->getString()); return si; }
};
SimpleHash<C,B> C::hToTerm;

//////////

typedef DelimitedJoint2DRV<psX,L,psColon,C,psX> G;
typedef DelimitedJoint2DRV<psX,B,psComma,G,psX> F;
typedef DelimitedJoint2DRV<psX,G,psLBrace,I,psRBrace> GI;
typedef DelimitedJoint2DRV<psX,B,psComma,GI,psX> Rd;
typedef DelimitedJoint2DRV<psX,G,psSpace,G,psX> GG;


//////////

typedef CPT4DModel<GG,U,D,GI,Prob>   MModel;
///typedef CPT3DModel<I,L,I,Prob>       LModel;
typedef CPT5DModel<I,U,D,L,I,Prob>   LModel;

typedef CPT4DModel<GI,U,D,GI,Prob>   MLModel;
typedef CPT3DModel<GI,D,GI,Prob>     GIstarModel;

typedef CPT4DModel<F,D,GI,GI,Prob>   FdgigiModel;
typedef CPT3DModel<  G,D,GI,Prob>    GdgiModel;
typedef CPT4DModel<I,D,G,GI,Prob>    IdggiModel;
typedef CPT4DModel<  G,D,Rd,GI,Prob> GdfigiModel;
typedef CPT5DModel<I,D,G,Rd,GI,Prob> IdgfigiModel;
typedef CPT4DModel<I,D,G,I,Prob>     IdgiModel;


///////////////////////////////////////////////////////////////////////////////

int main (int nArgs, char* argv[]) {


  //////////

  MModel modM;
  LModel modL;
  GIstarModel modGIstar;
  GIstarModel modGIzero;

  // Read in models...
  FILE* pf = stdin; assert(pf);                                                // READ MODEL FILE
  cerr<<"Loading model...\n";
  int c=' '; int i=0; int line=1; Array<char*> aps(100); String sBuff(1000);   // Lookahead/ctrs/buffers
  CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                   // Get to first record
  while ( c!=-1 && c!='\0' && c!='\5' ) {                                      // For each record
    CONSUME_STR ( pf, c, (c!='\n' && c!='\0' && c!='\5'), sBuff, i, line );    //   Consume line
    StringInput si(sBuff.c_array());
    if ( !( sBuff[0]=='#' ||                                                   //   Accept comments/fields
            si>>"M ">>modM>>"\0"!=NULL || 
            si>>"L ">>modL>>"\0"!=NULL || 
            si>>"G* ">>modGIstar>>"\0"!=NULL || 
            si>>"G0 ">>modGIzero>>"\0"!=NULL ) )
      ;//cerr<<"\nERROR: can't parse \'"<<sBuff<<"\' in line "<<line<<"\n\n";
    CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                 //   Consume whitespace
    if ( line%100000==0 ) cerr<<"  "<<line<<" lines read...\n";                //   Progress for big models
  }
  cerr<<"Model loaded.\n";

  //////////

  GIstarModel modGIplus;
  MLModel modML;

  // Define P_ML(gi_0|udgi_) = SUM g_1 . P_M(g_0,g_1|udgi_) * P_L(i_0|l_0,i_)...
  for ( MModel::const_iterator itM = modM.begin(); itM != modM.end(); ++itM ) {
    const U&  u_  = itM->first.getX1();
    const D&  d_  = itM->first.getX2();
    const GI& gi_ = itM->first.getX3();
    const I&  i_  = itM->first.getX3().second;
    const MModel::distribution& distM = itM->second;
    for ( MModel::distribution::const_iterator itdM = distM.begin(); itdM != distM.end(); ++itdM ) {
      const G& g_0 = itdM->first.first;
      const L& l_0 = itdM->first.first.first;
      Prob     prM = itdM->second;
      ///const LModel::distribution& distL = modL.getDist(l_0,i_);
      const LModel::distribution& distL = modL.getDist(U_L,d_,l_0,i_);
      for ( LModel::distribution::const_iterator itdL = distL.begin(); itdL != distL.end(); ++itdL ) {
        const I& i_0 = itdL->first;
        Prob     prL = itdL->second;
        GI gi_0 (g_0,i_0);
        modML.setProb(gi_0,u_,d_,gi_) += (prM * prL);
        //if ( U("r") == u_ ) {
        //  modGIzero.setProb(gi_0,D(d_.toInt()+1),gi_) += (prM * prL);
        //}
      }
    }
  }

  // Define P_G+ = P_G* - P_G0...
  for ( GIstarModel::const_iterator itGI = modGIstar.begin(); itGI != modGIstar.end(); ++itGI ) {
    const D&  d_  = itGI->first.getX1();
    const GI& gi_ = itGI->first.getX2();
    const GIstarModel::distribution& distGI = itGI->second;
    for ( GIstarModel::distribution::const_iterator itdGI = distGI.begin(); itdGI != distGI.end(); ++itdGI ) {
      const GI& gi_0k = itdGI->first;
      Prob      prGI  = itdGI->second;
      if ( prGI > modGIzero.getProb(gi_0k,d_,gi_) )
        modGIplus.setProb(gi_0k,d_,gi_) = prGI - modGIzero.getProb(gi_0k,d_,gi_);
    }
  }

  //modML.dump(cout,"ML");
  //modGIstar.dump(cout,"G*");
  //modGIplus.dump(cout,"G+");
  //modGIzero.dump(cout,"G0");

  //////////

  { FdgigiModel modFr;
    cerr<<"red\n";
    // Reduce models...
    // Define P_Fr(g_0k,0|dgi_,gi_0k) = P_GI0(gi_0k|dgi_) / P_GI*(gi_0k|dgi_)...
    // Define P_Fr(g_0k,1|dgi_,gi_0k) = P_GI+(gi_0k|dgi_) / P_GI*(gi_0k|dgi_)...
    for ( GIstarModel::const_iterator itGI = modGIstar.begin(); itGI != modGIstar.end(); ++itGI ) {
      const D&  d_  = itGI->first.getX1();
      const GI& gi_ = itGI->first.getX2();
      const GIstarModel::distribution& distGI = itGI->second;
      for ( GIstarModel::distribution::const_iterator itdGI = distGI.begin(); itdGI != distGI.end(); ++itdGI ) {
        const GI& gi_0k = itdGI->first;
        const G&  g_0k  = itdGI->first.first;
        Prob      prGI  = itdGI->second;
        if ( modGIzero.getProb(gi_0k,d_,gi_) > 0.0 && prGI > 0.0 )
          modFr.setProb(F(B_1,g_0k),d_,gi_0k,gi_) = modGIzero.getProb(gi_0k,d_,gi_) / prGI;
        if ( modGIplus.getProb(gi_0k,d_,gi_) > 0.0 && prGI > 0.0 )
          modFr.setProb(F(B_0,g_0k),d_,gi_0k,gi_) = modGIplus.getProb(gi_0k,d_,gi_) / prGI;
      }
    }
    modFr.normalize();  // b/c part of derived condition (gi_0k) not const or in initial condition (which is just gi_)...
    modFr.dump(cout,"Fr");
    modFr.clear();
  }

  { GdgiModel  modGe;
    IdggiModel modIe;
    cerr<<"exp\n";
    // Expand models...
    // Define P_Ge(     g_0k|dgi_) = SUM i_0k . P_GI*(gi_0k|dgi_)...
    // Define P_Ie(i_0k|g_0k,dgi_) =            P_GI*(gi_0k|dgi_)...
    for ( GIstarModel::const_iterator itGI = modGIstar.begin(); itGI != modGIstar.end(); ++itGI ) {
      const D&  d_  = itGI->first.getX1();
      const GI& gi_ = itGI->first.getX2();
      const GIstarModel::distribution& distGI = itGI->second;
      for ( GIstarModel::distribution::const_iterator itdGI = distGI.begin(); itdGI != distGI.end(); ++itdGI ) {
        const G& g_0k = itdGI->first.first;
        const C& c_0k = itdGI->first.first.second;
        const I& i_0k = itdGI->first.second;
        Prob     prGI = itdGI->second;
        if ( prGI > 0.0 && c_0k.getTerm() == B_1 ) {
          modGe.setProb(     g_0k,d_,gi_) += prGI;
          modIe.setProb(i_0k,d_,g_0k,gi_) += prGI;
        }
      }
    }
    modGe.dump(cout,"Ge");
    modGe.clear();
    modIe.normalize();  // b/c part of derived condition (g_0k) not const or in initial condition (which is just gi_)...
    modIe.dump(cout,"Ie");
    modIe.clear();
  }

  { GdfigiModel  modGtw;
    IdgiModel    modItw;
    cerr<<"awa\n";
    // Awaited transition models...
    // Define P_Gtw(    g_1|dgi_,gi_0) = SUM i_1 . P_M(g_0,g_1|gi_) * P_L(i_0|l_0,i_)                   / P_GI0(gi_0|gi_)
    // Define P_Itw(i_1|g_1,dgi_,gi_0) =           P_M(g_0,g_1|gi_) * P_L(i_0|l_0,i_) * P_L(i_1|l_1,i_) / P_GI0(gi_0|gi_)
    for ( MModel::const_iterator itM = modM.begin(); itM != modM.end(); ++itM ) {
      const U&   u_   = itM->first.getX1();
      if ( U_R == u_ ) {
        const D&  d_  = itM->first.getX2();
        const GI& gi_ = itM->first.getX3();
        const I&   i_  = itM->first.getX3().second;
        const MModel::distribution& distM = itM->second;
        for ( MModel::distribution::const_iterator itdM = distM.begin(); itdM != distM.end(); ++itdM ) {
          const G& g_0 = itdM->first.first;
          const L& l_0 = itdM->first.first.first;
          const G& g_1 = itdM->first.second;
          const L& l_1 = itdM->first.second.first;
          Prob     prM = itdM->second;
          ///const LModel::distribution& distL0 = modL.getDist(l_0,i_);
          const LModel::distribution& distL0 = modL.getDist(U_L,D(d_.toInt()+1),l_0,i_);
          for ( LModel::distribution::const_iterator itdL0 = distL0.begin(); itdL0 != distL0.end(); ++itdL0 ) {
            const I& i_0  = itdL0->first;
            Prob     prL0 = itdL0->second;
            GI gi_0 (g_0,i_0);
            ///const LModel::distribution& distL1 = modL.getDist(l_1,i_);
            const LModel::distribution& distL1 = modL.getDist(U_R,d_,l_1,i_);
            for ( LModel::distribution::const_iterator itdL1 = distL1.begin(); itdL1 != distL1.end(); ++itdL1 ) {
              const I& i_1  = itdL1->first;
              Prob     prL1 = itdL1->second;
              if ( (prM*prL0*prL1) > 0.0 && modGIzero.getProb(gi_0,D(d_.toInt()+1),gi_) > 0.0 ) {  // EVER FALSE???
                modGtw.setProb(    g_1,d_,Rd(B_1,gi_0),gi_) += (prM * prL0 * prL1 / modGIzero.getProb(gi_0,D(d_.toInt()+1),gi_));
                modItw.setProb(i_1,d_,g_1,              i_) += (prM * prL0 * prL1 / modGIzero.getProb(gi_0,D(d_.toInt()+1),gi_));
              }
            }
          }
        }
      }
    }
    modGtw.normalize();  // b/c part of derived condition (     gi_0) not const or in initial condition (which is just gi_)...
    modGtw.dump(cout,"Gtw");
    modGtw.clear();
    modItw.normalize();  // b/c part of derived condition (g_1,gi_0) not const or in initial condition (which is just gi_)...
    modItw.dump(cout,"Itw");
    modItw.clear();
  }

  { GdfigiModel  modGtaa;
    cerr<<"act-act\n";
    // Active component of active transition models...
    // Define P_Gtaa(     g_0k|d,gi_,gi_0k0)     = SUM i_0k . P_GI*(gi_0k|dgi_) * P_M(g_0k0,g_0k1|gi_0k) * P_L(i_0k0|l_0k0,i_0k) / P_GI+(gi_0k0|gi_)
    for ( GIstarModel::const_iterator itGI = modGIstar.begin(); itGI != modGIstar.end(); ++itGI ) {
      const D&  d_  = itGI->first.getX1();
      const GI& gi_ = itGI->first.getX2();
      const GIstarModel::distribution& distGI = itGI->second;
      for ( GIstarModel::distribution::const_iterator itdGI = distGI.begin(); itdGI != distGI.end(); ++itdGI ) {
        const GI& gi_0k = itdGI->first;
        const G&  g_0k  = itdGI->first.first;
        Prob      prGI  = itdGI->second;
        const MLModel::distribution& distML = modML.getDist(U_L,d_,gi_0k);
        for ( MLModel::distribution::const_iterator itdML = distML.begin(); itdML != distML.end(); ++itdML ) {
          const GI& gi_0k0 = itdML->first;
          Prob      prML   = itdML->second;
          if ( (prGI*prML) > 0.0 && modGIplus.getProb(gi_0k0,d_,gi_) > 0.0 )  // EVER FALSE???
            modGtaa.setProb(     g_0k,d_,Rd(B_0,gi_0k0),gi_) += ( prML * (prGI / modGIplus.getProb(gi_0k0,d_,gi_)) );
        }
      }
    }
    modGtaa.normalize();  // b/c part of derived condition (      gi_0k0) not const or in initial condition (which is just gi_)...
    modGtaa.dump(cout,"Gtaa");
    modGtaa.clear();
  }
  { IdgfigiModel modItaa;
    cerr<<"act-act\n";
    // Active component of active transition models...
    // Define P_Itaa(i_0k|g_0k,d,gi_,gi_0k0)     =            P_GI*(gi_0k|dgi_) * P_M(g_0k0,g_0k1|gi_0k) * P_L(i_0k0|l_0k0,i_0k) / P_GI+(gi_0k0|gi_)
    for ( GIstarModel::const_iterator itGI = modGIstar.begin(); itGI != modGIstar.end(); ++itGI ) {
      const D&  d_  = itGI->first.getX1();
      const GI& gi_ = itGI->first.getX2();
      const GIstarModel::distribution& distGI = itGI->second;
      for ( GIstarModel::distribution::const_iterator itdGI = distGI.begin(); itdGI != distGI.end(); ++itdGI ) {
        const GI& gi_0k = itdGI->first;
        const G&  g_0k  = itdGI->first.first;
        const I&  i_0k  = itdGI->first.second;
        Prob      prGI  = itdGI->second;
        const MLModel::distribution& distML = modML.getDist(U_L,d_,gi_0k);
        for ( MLModel::distribution::const_iterator itdML = distML.begin(); itdML != distML.end(); ++itdML ) {
          const GI& gi_0k0 = itdML->first;
          Prob      prML   = itdML->second;
          if ( (prGI*prML) > 0.0 && modGIplus.getProb(gi_0k0,d_,gi_) > 0.0 )  // EVER FALSE???
            modItaa.setProb(i_0k,d_,g_0k,Rd(B_0,gi_0k0),gi_) += ( prML * (prGI / modGIplus.getProb(gi_0k0,d_,gi_)) );
        }
      }
    }
    modItaa.normalize();  // b/c part of derived condition (g_0k,gi_0k0) not const or in initial condition (which is just gi_)...
    modItaa.dump(cout,"Itaa");
    modItaa.clear();
  }

  { GdfigiModel  modGtaw;
    IdgiModel    modItaw;
    cerr<<"act-awa\n";
    // Awaited component of active transition models...
    // Define P_Gtaw(      g_0k1|d,gi_0k,gi_0k0) = SUM i_0k1 . P_M(g_0k0,g_0k1|gi_0k) * P_L(i_0k0|l_0k0,i_0k) * P_L(i_0k1|l_0k1,i0k) / P_GI+(gi_0k0|gi_)
    // Define P_Itaw(i_0k1|g_0k1,d,gi_0k,gi_0k0) =             P_M(g_0k0,g_0k1|gi_0k) * P_L(i_0k0|l_0k0,i_0k) * P_L(i_0k1|l_0k1,i0k) / P_GI+(gi_0k0|gi_)
    for ( MModel::const_iterator itM = modM.begin(); itM != modM.end(); ++itM ) {
      const U&  u_  = itM->first.getX1();
      if ( U_L == u_ ) {
        const D&  d_    = itM->first.getX2();
        const GI& gi_0k = itM->first.getX3();
        const I&  i_0k  = itM->first.getX3().second;
        const MModel::distribution& distM = itM->second;
        for ( MModel::distribution::const_iterator itdM = distM.begin(); itdM != distM.end(); ++itdM ) {
          const G& g_0k0 = itdM->first.first;
          const L& l_0k0 = itdM->first.first.first;
          const G& g_0k1 = itdM->first.second;
          const L& l_0k1 = itdM->first.second.first;
          Prob     prM   = itdM->second;
          ///const LModel::distribution& distL0 = modL.getDist(l_0k0,i_0k);
          const LModel::distribution& distL0 = modL.getDist(U_L,d_,l_0k0,i_0k);
          for ( LModel::distribution::const_iterator itdL0 = distL0.begin(); itdL0 != distL0.end(); ++itdL0 ) {
            const I& i_0k0 = itdL0->first;
            Prob     prL0  = itdL0->second;
            GI gi_0k0 (g_0k0,i_0k0);
            ///const LModel::distribution& distL1 = modL.getDist(l_0k1,i_0k);
            const LModel::distribution& distL1 = modL.getDist(U_R,d_,l_0k1,i_0k);
            for ( LModel::distribution::const_iterator itdL1 = distL1.begin(); itdL1 != distL1.end(); ++itdL1 ) {
              const I& i_0k1 = itdL1->first;
              Prob     prL1  = itdL1->second;
              if ( (prM*prL0*prL1) > 0.0 ) {
                modGtaw.setProb(      g_0k1,d_,Rd(B_0,gi_0k0),gi_0k) += (prM * prL0 * prL1);
                modItaw.setProb(i_0k1,d_,g_0k1,                i_0k) += (prM * prL0 * prL1);
              }
            }
          }
        }
      }
    }
    modGtaw.normalize();  // b/c part of derived condition (       gi_0k,gi_0k0) not const or in initial condition (which is just gi_)...
    modGtaw.dump(cout,"Gtaw");
    modGtaw.clear();
    modItaw.normalize();  // b/c part of derived condition (g_0k1,gi_0k,gi_0k0) not const or in initial condition (which is just gi_)...
    modItaw.dump(cout,"Itaw");
    modItaw.clear();
  }

  cerr<<"done\n";

}
