###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

######################################################################
# pushDownPBRLabels.rb
# 
# PropBank SRL labels on the non-leaf node will be pushed down to the leaf
# nodes. This is useful when doing eval. This is the reversed operation
# of pushUpPBRLabels.rb
#
# TO RUN: cat genmode/pbrtrees | ruby scripts/pushDownPBRLabels.rb 
#
######################################################################

require "scripts/umnlp.rb"

$ID = /ID\!pbrdelim\!/
$NON_ID = /(REL|ARG)([^\!]*)\!pbrdelim\!/
#####
class Tree
  
  def pushDown (pbr="ID")
#    $stderr.print @head, "\n"
    if @children.size == 0
      @head = @head + ":" + (pbr == "ID" ? "NULL" : pbr)
      self
    elsif @head.match($ID)
      @head.sub!($ID, "")
      @children.each { |c| c.pushDown(pbr) }
      self
    elsif @head.match($NON_ID)
      nonId = @head.match($NON_ID)
      @head.sub!($NON_ID, "")
      @children.each { |c| c.pushDown(nonId[1] + nonId[2]) }
      self
    end
  end
  
end

##########################################

$lineNum = 0
#File.open("ttt").each_line do |line| 
while (line = STDIN.gets)
  $lineNum = $lineNum + 1
  t = Tree.new(line).pushDown
  print t.to_s, "\n"
end
