"""
Functions:
    It utilises prediction result and calculates performances of detection under different settings.
"""
import sys
def eval(suffix, threshold):
    flog = open('../result/curveData', 'a') #experimental result file
    fpredict = open('../dect/result.' + suffix) #predictions from SVM classifier
    foracle = open('../dect/oracle.' + suffix) #ground truth 
    TP = 0 # True Positive, hereafter.
    TN = 0
    FP = 0
    FN = 0
    while True:
        line  = foracle.readline().rstrip()
        if not line:
            break
        tokens= line.split('\t')
        num = int(tokens[0])
        truth = int(tokens[1]) #ground truth flag
        if num == 0: # conservative in labeling positives (ill-formed words) when there are no candidates with valid features.
            if truth == 1:
                TN += 1
            else:
                FN += 1
            continue
        tmpList = list()
        for i in range(num):
            line = fpredict.readline().rstrip()
            tmpList.append(int(line))
        judger = sum(1 for tmp in tmpList if tmp > 0) # For each checkpoint, get the summation of positive predictions.
        if judger >= threshold and truth == 1: # TP: An ill-formed word is detected (judger is large than threshold)
            TP += 1
        elif judger >= threshold and truth == -1:
            FP += 1
        elif truth == 1:
            TN += 1
        else:
            FN += 1
    fpredict.close()
    foracle.close()

    prec = float(TP) / (TP + FP)
    recall = float(TP) / (TP + TN)
    flog.write("{0}\t{1}\t".format(suffix, threshold))
    flog.write("{0}\t{1}\t{2}\t{3}\t".format(TP, FP, TN, FN))
    flog.write("{0:4.2%}\t".format(prec))
    flog.write("{0:4.2%}\t".format(recall))
    flog.write("{0:4.2%}\n".format(2 * prec * recall / (prec + recall)))
    flog.close()

if __name__ == "__main__":
    if len(sys.argv) == 2:
        eval(sys.argv[1])
    elif len(sys.argv) == 3:
        eval(sys.argv[1],int(sys.argv[2]))
    else:
        print "{0} suffixName [threshold]".format(sys.argv[0])
