/*
 * Decompiled with CFR 0.152.
 */
package main.lexinduct;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.context.Context;
import babel.ranking.EquivClassCandRanking;
import babel.ranking.MRRAggregator;
import babel.ranking.Ranker;
import babel.ranking.Reranker;
import babel.ranking.scorers.Scorer;
import babel.ranking.scorers.context.DictScorer;
import babel.ranking.scorers.context.FungS1Scorer;
import babel.ranking.scorers.edit.EditDistanceScorer;
import babel.ranking.scorers.timedistribution.TimeDistributionCosineScorer;
import babel.util.config.Configurator;
import babel.util.dict.Dictionary;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import main.lexinduct.DataPreparer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NBestCollector {
    public static final Log LOG = LogFactory.getLog(NBestCollector.class);
    protected static int[] K = new int[]{1, 5, 10, 20, 30, 40, 50, 60, 80, 100, 200, 300, 400, 500};

    public static void main(String[] args) throws Exception {
        LOG.info((Object)("\n" + Configurator.getConfigDescriptor()));
        NBestCollector collector = new NBestCollector();
        collector.runTwoLanguages();
    }

    protected void runTwoLanguages() throws Exception {
        Collection<EquivClassCandRanking> cands;
        boolean slidingWindow = Configurator.CONFIG.getBoolean("experiments.time.SlidingWindow");
        int windowSize = Configurator.CONFIG.getInt("experiments.time.WindowSize");
        int maxNumTrgPerSrc = Configurator.CONFIG.getInt("experiments.NumTranslationsToAddPerSource");
        String outDir = Configurator.CONFIG.getString("output.Path");
        int numThreads = Configurator.CONFIG.getInt("experiments.NumRankingThreads");
        boolean doContext = Configurator.CONFIG.getBoolean("experiments.DoContext");
        boolean doTime = Configurator.CONFIG.getBoolean("experiments.DoTime");
        boolean doEditDist = Configurator.CONFIG.getBoolean("experiments.DoEditDistance");
        boolean doAggregate = Configurator.CONFIG.getBoolean("experiments.DoAggregate");
        DataPreparer preparer = new DataPreparer();
        preparer.prepare();
        Set<EquivalenceClass> srcSubset = preparer.getSrcEqsToInduct();
        Set<EquivalenceClass> trgSet = preparer.getTrgEqs();
        FungS1Scorer contextScorer = new FungS1Scorer(preparer.getSeedDict(), preparer.getMaxSrcTokCount(), preparer.getMaxTrgTokCount());
        TimeDistributionCosineScorer timeScorer = new TimeDistributionCosineScorer(windowSize, slidingWindow);
        EditDistanceScorer editScorer = new EditDistanceScorer();
        preparer.prepareProperties(true, srcSubset, contextScorer, timeScorer);
        preparer.prepareProperties(false, preparer.getTrgEqs(), contextScorer, timeScorer);
        HashSet<Collection<EquivClassCandRanking>> allCands = new HashSet<Collection<EquivClassCandRanking>>();
        if (doTime) {
            LOG.info((Object)"Ranking candidates using time...");
            cands = this.rank(timeScorer, srcSubset, trgSet, maxNumTrgPerSrc, numThreads);
            this.evaluate(cands, preparer.getTestDict(), String.valueOf(outDir) + "time.eval");
            EquivClassCandRanking.dumpToFile(preparer.getTestDict(), cands, String.valueOf(outDir) + "time.scored");
            allCands.add(cands);
        }
        if (doContext) {
            LOG.info((Object)"Ranking candidates using context...");
            cands = this.rank(contextScorer, srcSubset, trgSet, maxNumTrgPerSrc, 0.0, numThreads);
            this.evaluate(cands, preparer.getTestDict(), String.valueOf(outDir) + "context.eval");
            EquivClassCandRanking.dumpToFile(preparer.getTestDict(), cands, String.valueOf(outDir) + "context.scored");
            allCands.add(cands);
        }
        if (doEditDist) {
            LOG.info((Object)"Ranking candidates using edit distance...");
            cands = this.rank(editScorer, srcSubset, trgSet, maxNumTrgPerSrc, numThreads);
            this.evaluate(cands, preparer.getTestDict(), String.valueOf(outDir) + "edit.eval");
            EquivClassCandRanking.dumpToFile(preparer.getTestDict(), cands, String.valueOf(outDir) + "edit.scored");
            allCands.add(cands);
        }
        if (doAggregate) {
            LOG.info((Object)"Aggregating (MRR) all rankings...");
            MRRAggregator aggregator = new MRRAggregator();
            cands = aggregator.aggregate(allCands);
            this.evaluate(cands, preparer.getTestDict(), String.valueOf(outDir) + "aggmrr.eval");
            EquivClassCandRanking.dumpToFile(preparer.getTestDict(), cands, String.valueOf(outDir) + "aggmrr.scored");
        }
        LOG.info((Object)"--- Done ---");
    }

    protected Collection<EquivClassCandRanking> rank(Scorer scorer, Set<EquivalenceClass> srcSubset, Set<EquivalenceClass> trgSet, int maxNumberPerSrc, double threshold, int numThreads) throws Exception {
        Ranker ranker = new Ranker(scorer, maxNumberPerSrc, threshold, numThreads);
        return ranker.getBestCandLists(srcSubset, trgSet);
    }

    protected Collection<EquivClassCandRanking> rank(Scorer scorer, Set<EquivalenceClass> srcSubset, Set<EquivalenceClass> trgSet, int maxNumberPerSrc, int numThreads) throws Exception {
        Ranker ranker = new Ranker(scorer, maxNumberPerSrc, numThreads);
        return ranker.getBestCandLists(srcSubset, trgSet);
    }

    protected Collection<EquivClassCandRanking> reRank(Scorer scorer, Collection<EquivClassCandRanking> cands) {
        Reranker reranker = new Reranker(scorer);
        return reranker.reRank(cands);
    }

    protected Collection<EquivClassCandRanking> reRank(Scorer scorer, Collection<EquivClassCandRanking> cands, double threshold) {
        Reranker reranker = new Reranker(scorer, threshold);
        return reranker.reRank(cands);
    }

    protected void pruneContextsAccordingToScore(Set<EquivalenceClass> srcEqs, Set<EquivalenceClass> trgEqs, DictScorer scorer) {
        Context.ScoreComparator comparator = new Context.ScoreComparator(scorer);
        int pruneContextEqs = Configurator.CONFIG.getInt("experiments.context.PruneContextToSize");
        for (EquivalenceClass ec : srcEqs) {
            ((Context)ec.getProperty(Context.class.getName())).pruneContext(pruneContextEqs, comparator);
        }
        for (EquivalenceClass ec : trgEqs) {
            ((Context)ec.getProperty(Context.class.getName())).pruneContext(pruneContextEqs, comparator);
        }
    }

    protected void evaluate(Collection<EquivClassCandRanking> cands, Dictionary testDict, String outFileName) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(outFileName));
        DecimalFormat df = new DecimalFormat("0.00");
        writer.write("K\tAccuracy@TopK\tNumInDict");
        writer.newLine();
        int i = 0;
        while (i < K.length) {
            double oneInTopK = 0.0;
            double total = 0.0;
            for (EquivClassCandRanking ranking : cands) {
                Set<EquivalenceClass> goldTrans = testDict.translate(ranking.getEqClass());
                if (goldTrans == null) continue;
                oneInTopK += (double)(ranking.numInTopK(goldTrans, K[i]) > 0 ? 1 : 0);
                total += 1.0;
            }
            double accInTopK = 100.0 * oneInTopK / total;
            writer.write(String.valueOf(K[i]) + "\t" + df.format(accInTopK) + "\t" + total);
            writer.newLine();
            ++i;
        }
        writer.close();
    }
}

