/*
 * Decompiled with CFR 0.152.
 */
package babel.prep.datedcorpus;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.MultipleOutputFormat;
import org.apache.hadoop.util.Progressable;

public class DatedLangFilesOutputFormat
extends MultipleOutputFormat<Text, Text> {
    static final Log LOG = LogFactory.getLog(DatedLangFilesOutputFormat.class);
    static final String DEFAULT_CHARSET = "UTF-8";
    static final String REJECTED_FILE = "rejected.txt";
    static final String EXTENSION = ".txt";

    protected String generateFileNameForKeyValue(Text key, Text ver, String name) {
        String[] toks = key.toString().split("-");
        if (toks == null || toks.length != 2) {
            return REJECTED_FILE;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(Long.parseLong(toks[1]));
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        if (year < 2000 || year > 2011) {
            return REJECTED_FILE;
        }
        return String.valueOf(toks[0]) + File.separator + year + File.separator + year + "-" + month + "-" + day + EXTENSION;
    }

    public RecordWriter<Text, Text> getBaseRecordWriter(FileSystem fs, JobConf job, String name, Progressable progress) throws IOException {
        final Path dumpFile = new Path(FileOutputFormat.getOutputPath((JobConf)job), name);
        if (fs.exists(dumpFile)) {
            fs.delete(dumpFile, true);
        } else {
            fs.mkdirs(dumpFile.getParent());
        }
        return new RecordWriter<Text, Text>(){

            public synchronized void write(Text key, Text versText) throws IOException {
                try {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(dumpFile.toUri()), true), DatedLangFilesOutputFormat.DEFAULT_CHARSET));
                    writer.write(versText.toString());
                    writer.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error writing page versions: " + e.toString());
                }
            }

            public synchronized void close(Reporter reporter) throws IOException {
            }
        };
    }
}

