package org.maltparser.parser.algorithm.twoplanar3T;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.Function;
import org.maltparser.parser.AbstractParserFactory;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.planar3TLabelStrat.Planar3TLabelStratConfig;
import org.maltparser.parser.algorithm.twoplanar.TwoPlanarConfig;

public abstract class TwoPlanar3TFactory implements AbstractParserFactory {
	protected Algorithm algorithm;
	protected DependencyParserConfig manager;
	
	public TwoPlanar3TFactory(Algorithm algorithm) {
		setAlgorithm(algorithm);
		setManager(algorithm.getManager());
	}
	
	public ParserConfiguration makeParserConfiguration() throws MaltChainedException {
		if (manager.getConfigLogger().isInfoEnabled()) {
			manager.getConfigLogger().info("  Parser configuration : Two-Planar 3T with no_covered_roots = " + manager.getOptionValue("planar3tlab", "no_covered_roots").toString().toUpperCase() + ", " + "acyclicity = " + manager.getOptionValue("planar3tlab", "acyclicity").toString().toUpperCase() + ", planar root handling = " + manager.getOptionValue("2planar3t" , "planar_root_handling").toString().toUpperCase() + ", reduce on switch = " + manager.getOptionValue("2planar3t" , "reduceonswitch").toString().toUpperCase() + ", reconstruction technique = " + manager.getOptionValue("2planar3t" , "2reconstruction").toString() + ", heuristic = " + manager.getOptionValue("2planar3t" , "2heuristic").toString() + "\n");
		}
		return new TwoPlanar3TConfig(manager.getSymbolTables() , manager.getOptionValue("planar3tlab", "no_covered_roots").toString() , manager.getOptionValue("planar3tlab", "acyclicity").toString() , manager.getOptionValue("2planar3t" , "reduceonswitch").toString()  , manager.getOptionValue("2planar3t" , "planar_root_handling").toString(), manager.getOptionValue("2planar3t" , "2reconstruction").toString(), manager.getOptionValue("2planar3t" , "2heuristic").toString()  );
	}

	
	public Function makeFunction(String subFunctionName) throws MaltChainedException {
		return new TwoPlanar3TAddressFunction(subFunctionName, algorithm);
	}

	public Algorithm getAlgorithm() {
		return algorithm;
	}

	public void setAlgorithm(Algorithm algorithm) {
		this.algorithm = algorithm;
	}

	public DependencyParserConfig getManager() {
		return manager;
	}

	public void setManager(DependencyParserConfig manager) {
		this.manager = manager;
	}
}