package org.maltparser.parser.algorithm.planar3TLabelStrat;


import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.Function;
import org.maltparser.parser.AbstractParserFactory;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.ParserConfiguration;

public abstract class Planar3TLabelStratFactory implements AbstractParserFactory {
	protected Algorithm algorithm;
	protected DependencyParserConfig manager;
	
	public Planar3TLabelStratFactory(Algorithm algorithm) {
		setAlgorithm(algorithm);
		setManager(algorithm.getManager());
	}
	
	public ParserConfiguration makeParserConfiguration() throws MaltChainedException {
		if (manager.getConfigLogger().isInfoEnabled()) {
			manager.getConfigLogger().info("  Parser configuration : Planar 3T Label Strategy with no_covered_roots = " + manager.getOptionValue("planar3tlab", "no_covered_roots").toString().toUpperCase() + ", " + "acyclicity = " + manager.getOptionValue("planar3tlab", "acyclicity").toString().toUpperCase() + ", connectedness = " + manager.getOptionValue("planar3tlab", "connectedness").toString().toUpperCase() +", heuristic = " + manager.getOptionValue("planar3tlab", "heuristic").toString().toUpperCase() +", "+ "root handling = "+manager.getOptionValue("planar3tlab" , "planar_root_handling").toString().toUpperCase()+ "\n");
		}
		return new Planar3TLabelStratConfig(manager.getSymbolTables() , manager.getOptionValue("planar3tlab", "no_covered_roots").toString() , manager.getOptionValue("planar3tlab", "acyclicity").toString() , manager.getOptionValue("planar3tlab", "connectedness").toString(), manager.getOptionValue("planar3tlab" , "planar_root_handling").toString(), manager.getOptionValue("planar3tlab" , "heuristic").toString());
	}
	
	public Function makeFunction(String subFunctionName) throws MaltChainedException {
		return new Planar3TLabelStratAddressFunction(subFunctionName, algorithm);
	}

	public Algorithm getAlgorithm() {
		return algorithm;
	}

	public void setAlgorithm(Algorithm algorithm) {
		this.algorithm = algorithm;
	}

	public DependencyParserConfig getManager() {
		return manager;
	}

	public void setManager(DependencyParserConfig manager) {
		this.manager = manager;
	}
}
