/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.moreTransition;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.Oracle;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.moreTransition.MoreTransitionConfig;
import org.maltparser.parser.history.GuideUserHistory;
import org.maltparser.parser.history.action.GuideUserAction;

public class MoreTransitionOracle
extends Oracle {
    public MoreTransitionOracle(DependencyParserConfig manager, GuideUserHistory history) throws MaltChainedException {
        super(manager, history);
        this.setGuideName("MT");
    }

    public GuideUserAction predict(DependencyStructure gold, ParserConfiguration config) throws MaltChainedException {
        MoreTransitionConfig planarConfig = (MoreTransitionConfig)config;
        DependencyStructure dg = planarConfig.getDependencyGraph();
        DependencyNode stackPeek = planarConfig.getStack().peek();
        int stackPeekIndex = stackPeek.getIndex();
        int inputPeekIndex = planarConfig.getInput().peek().getIndex();
        DependencyNode inputPeek = planarConfig.getInput().peek();
        int inputPeek2Index = 0;
        if (planarConfig.getInput().size() >= 2) {
            DependencyNode inputPeek2 = (DependencyNode)planarConfig.getInput().get(planarConfig.getInput().size() - 2);
            inputPeek2Index = inputPeek2.getIndex();
        }
        int inputPeek3Index = 0;
        if (planarConfig.getInput().size() >= 3) {
            DependencyNode inputPeek3 = (DependencyNode)planarConfig.getInput().get(planarConfig.getInput().size() - 3);
            inputPeek3Index = inputPeek3.getIndex();
        }
        if (planarConfig.getInput().size() >= 2 && gold.getTokenNode(inputPeekIndex).getHead().getIndex() == inputPeek2Index && !this.checkIfArcExists(dg, inputPeek2Index, inputPeekIndex)) {
            return this.updateActionContainers(5, gold.getTokenNode(inputPeekIndex).getHeadEdge().getLabelSet());
        }
        if (!stackPeek.isRoot() && gold.getTokenNode(stackPeekIndex).getHead().getIndex() == inputPeekIndex && !this.checkIfArcExists(dg, inputPeekIndex, stackPeekIndex)) {
            return this.updateActionContainers(4, gold.getTokenNode(stackPeekIndex).getHeadEdge().getLabelSet());
        }
        if (gold.getTokenNode(inputPeekIndex).getHead().getIndex() == stackPeekIndex && !this.checkIfArcExists(dg, stackPeekIndex, inputPeekIndex)) {
            return this.updateActionContainers(3, gold.getTokenNode(inputPeekIndex).getHeadEdge().getLabelSet());
        }
        if (gold.getTokenNode(inputPeekIndex).hasLeftDependent() && gold.getTokenNode(inputPeekIndex).getLeftmostDependent().getIndex() < stackPeekIndex) {
            return this.updateActionContainers(2, null);
        }
        if (gold.getTokenNode(inputPeekIndex).getHead().getIndex() < stackPeekIndex) {
            return this.updateActionContainers(2, null);
        }
        return this.updateActionContainers(1, null);
    }

    private boolean checkIfArcExists(DependencyStructure dg, int index1, int index2) throws MaltChainedException {
        return dg.getTokenNode(index2).hasHead() && dg.getTokenNode(index2).getHead().getIndex() == index1;
    }

    public void finalizeSentence(DependencyStructure dependencyGraph) throws MaltChainedException {
    }

    public void terminate() throws MaltChainedException {
    }
}

