/* hard formulas */

/* (hf1) If a phrase is chosen, then it must have a mapped semantic item. */
factor: for Int l if candPhrase(l): hasPhrase(l) => |Int r: candResource(r) & hasResource(l,r)| >= 1;

/* (fh2)  If a semantic item is chosen, then its mapping phrase must be chosen./
factor: for Int p, Int r
	if candPhrase(p) & candResource(r) & priorMatch(p, r) & hasResource(p, r): hasPhrase(p);

/* (hf3)  A phrase can be mapped to one semantic item at most.*/
factor: for Int p if candPhrase(p): |Int r : candResource(r) & hasResource(p,r)| <= 1;

factor: for Int p, Int r if candPhrase(p) & candResource(r) : !hasPhrase(p) => !hasResource(p, r);

/* (hf6) Two semantic items have one relation at most.*/
factor: for Int r1, Int r2 if candResource(r1) & candResource(r2) : |RelationRole rr : hasRelation(r1, r2, rr)| <= 1;
	
/* (fh5) If a semantic item is chosen, then it should have one relation with other semantic items at least.*/
factor: for Int r1, Int r2, RelationRole rr if candResource(r1) & candResource(r2):
	hasRelation(r1, r2, rr) => |Int p : candPhrase(p) & hasResource(p,r1)| >= 1;
factor: for Int r1, Int r2, RelationRole rr if candResource(r1) & candResource(r2):
	hasRelation(r1, r2, rr) => |Int p : candPhrase(p) & hasResource(p,r2)| >= 1;	
	

/* factor: for Int r1, Int r2, Int p if candPhrase(p) & candResource(r1) & candResource(r2):
	!hasRelation(r1, r2, "1_1") => !hasResource(p,r1);
factor: for Int r1, Int r2, Int p if candPhrase(p) & candResource(r1) & candResource(r2):
	!hasRelation(r1, r2, "1_1") => !hasResource(p,r2);
factor: for Int r1, Int r2, Int p if candPhrase(p) & candResource(r1) & candResource(r2):
	!hasRelation(r1, r2, "1_2") => !hasResource(p,r1);
factor: for Int r1, Int r2, Int p if candPhrase(p) & candResource(r1) & candResource(r2):
	!hasRelation(r1, r2, "1_2") => !hasResource(p,r2);
factor: for Int r1, Int r2, Int p if candPhrase(p) & candResource(r1) & candResource(r2):
	!hasRelation(r1, r2, "2_1") => !hasResource(p,r1);
factor: for Int r1, Int r2, Int p if candPhrase(p) & candResource(r1) & candResource(r2):
	!hasRelation(r1, r2, "2_1") => !hasResource(p,r2);
factor: for Int r1, Int r2, Int p if candPhrase(p) & candResource(r1) & candResource(r2):
	!hasRelation(r1, r2, "2_2") => !hasResource(p,r1);
factor: for Int r1, Int r2, Int p if candPhrase(p) & candResource(r1) & candResource(r2):
	!hasRelation(r1, r2, "2_2") => !hasResource(p,r2);*/
	
/* (hf8)  Each two chosen phrases must not overlap.*/
factor: for Int p1, Int p2, Int r1, Int r2, Int s1, Int e1, Int s2, Int e2
	if candPhrase(p1) & candPhrase(p2) & p1 != p2 & candResource(r1) & candResource(r2) & phraseIndex(p1, s1, e1) & phraseIndex(p2, s2, e2) & (s1 >= s2) & (e2 >= s1):
	hasPhrase(p1) => !hasPhrase(p2);

factor: for Int p1, Int p2, Int r1, Int r2, Int s1, Int e1, Int s2, Int e2
	if candPhrase(p1) & candPhrase(p2) & p1 != p2 & candResource(r1) & candResource(r2) & phraseIndex(p1, s1, e1) & phraseIndex(p2, s2, e2) & (s1 >= s2) & (e2 >= s1):
	hasPhrase(p2) => !hasPhrase(p1);

factor: for Int p1, Int p2, Int r1, Int r2, Int s1, Int e1, Int s2, Int e2
	if candPhrase(p1) & candPhrase(p2) & p1 != p2 & candResource(r1) & candResource(r2) & phraseIndex(p1, s1, e1) & phraseIndex(p2, s2, e2) & (s2 >= s1) & (e1 >= s2):
	hasPhrase(p1) => !hasPhrase(p2);

factor: for Int p1, Int p2, Int r1, Int r2, Int s1, Int e1, Int s2, Int e2
	if candPhrase(p1) & candPhrase(p2) & p1 != p2 & candResource(r1) & candResource(r2) & phraseIndex(p1, s1, e1) & phraseIndex(p2, s2, e2) & (s2 >= s1) & (e1 >= s2):
	hasPhrase(p2) => !hasPhrase(p1);
	

/* (sf4)  There have some associations between the dependency tags in the dependency pattern path of two phases and the types of relation of two mapped semantic items.*/	
weight w_deppath_rr: DepTag x RelationRole -> Double;
factor: for Int p1, Int p2, Int r1, Int r2, DepTag dp, RelationRole rr
	if candPhrase(p1) & candPhrase(p2) & p1 != p2 & candResource(r1) & candResource(r2) & phraseDepTag(p1, p2, dp) & isTypeCompatible(r1, r2, rr) & priorMatch(p1, r1) & priorMatch(p2, r2)
	add [hasResource(p1, r1) & hasResource(p2, r2) => hasRelation(r1, r2, rr)] * w_deppath_rr(dp, rr);

/* (sf5) */
weight w_deppath_nomean_rr: DepTag x RelationRole -> Double;
factor: for Int p1, Int p2, Int r1, Int r2, DepTag dp, RelationRole rr
	if candPhrase(p1) & candPhrase(p2) & p1 != p2 & candResource(r1) & candResource(r2) & phraseDepTag(p1, p2, dp) & !hasMeanWord(p1, p2) & isTypeCompatible(r1, r2, rr) & priorMatch(p1, r1) & priorMatch(p2, r2)
	add [hasResource(p1, r1) & hasResource(p2, r2) => hasRelation(r1, r2, rr)] * w_deppath_nomean_rr(dp, rr);
	
/* (sf6) */
weight w_deppath_one_rr: DepTag x RelationRole -> Double;
factor: for Int p1, Int p2, Int r1, Int r2, DepTag dp, RelationRole rr
	if candPhrase(p1) & candPhrase(p2) & p1 != p2 & candResource(r1) & candResource(r2) & phraseDepTag(p1, p2, dp) & phraseDepOne(p1, p2) & isTypeCompatible(r1, r2, rr) & priorMatch(p1, r1) & priorMatch(p2, r2)
	add [hasResource(p1, r1) & hasResource(p2, r2) => hasRelation(r1, r2, rr)] * w_deppath_one_rr(dp, rr);	
	
	
/* (sf7) The larger the relatedness of two semantic items is, the more likely they have a relation. */
weight w_relatedness_rr: RelationRole -> Double;
factor: for Int p1, Int p2, Int r1, Int r2, RelationRole rr, Double s
	if candPhrase(p1) & candPhrase(p2) & p1 != p2 & candResource(r1) & candResource(r2) & hasRelatedness(r1, r2, s) & isTypeCompatible(r1, r2, rr) & priorMatch(p1, r1) & priorMatch(p2, r2)
	add [hasResource(p1, r1) & hasResource(p2, r2) => hasRelation(r1, r2, rr)] * s * w_relatedness_rr(rr);	
	
