/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.hmm;

import com.aliasi.classify.Classification;
import com.aliasi.classify.ClassifierEvaluator;
import com.aliasi.classify.JointClassification;
import com.aliasi.hmm.TagWordLattice;
import com.aliasi.util.Arrays;
import com.aliasi.util.ObjectToCounterMap;
import com.aliasi.util.ScoredObject;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class HmmEvaluation {
    private final ClassifierEvaluator<String, Classification> mFirstBestEvaluation;
    private final ClassifierEvaluator<String, JointClassification> mLatticeEvaluation;
    private final ObjectToCounterMap<Integer> mNBestHistogram;
    private final int mMaxNBest;
    private final Set<String> mKnownTokenSet = new HashSet<String>();
    private long mNumTokens = 0L;
    private long mNumCases = 0L;
    private long mNumCasesCorrect = 0L;
    private long mNumUnknownTokens = 0L;
    private long mNumUnknownTokensCorrect = 0L;
    private int mLastNBest;

    public HmmEvaluation(String[] tags, int maxNBest) {
        this.mFirstBestEvaluation = new ClassifierEvaluator(null, tags);
        this.mLatticeEvaluation = new ClassifierEvaluator(null, tags);
        this.mNBestHistogram = new ObjectToCounterMap();
        this.mMaxNBest = maxNBest;
    }

    public long numCases() {
        return this.mNumCases;
    }

    public long numTokens() {
        return this.mNumTokens;
    }

    public int maxNBest() {
        return this.mMaxNBest;
    }

    @Deprecated
    public ClassifierEvaluator<String, Classification> firstBestEvaluation() {
        return this.mFirstBestEvaluation;
    }

    @Deprecated
    public ClassifierEvaluator<String, JointClassification> confidenceEvaluation() {
        return this.mLatticeEvaluation;
    }

    public ObjectToCounterMap<Integer> nBestHistogram() {
        return this.mNBestHistogram;
    }

    @Deprecated
    public void addCase(String[] tokens, String[] referenceTags, String[] responseTags, TagWordLattice lattice, Iterator<ScoredObject<String[]>> nBestIterator) {
        this.addFirstBestCase(tokens, referenceTags, responseTags);
        this.addLatticeCase(tokens, referenceTags, lattice);
        this.addNBestCase(tokens, referenceTags, nBestIterator);
    }

    public void addFirstBestCase(String[] tokens, String[] referenceTags, String[] responseTags) {
        int i;
        HmmEvaluation.verifyEqualLengths("tokens", "referenceTags", tokens, referenceTags);
        HmmEvaluation.verifyEqualLengths("tokens", "responseTags", tokens, responseTags);
        this.mNumTokens += (long)tokens.length;
        ++this.mNumCases;
        if (Arrays.equals(referenceTags, responseTags)) {
            ++this.mNumCasesCorrect;
        }
        for (i = 0; i < tokens.length; ++i) {
            Classification result = new Classification(responseTags[i]);
            this.mFirstBestEvaluation.addClassification(referenceTags[i], result);
        }
        for (i = 0; i < tokens.length; ++i) {
            if (this.knownTokenSet().contains(tokens[i])) continue;
            ++this.mNumUnknownTokens;
            if (!referenceTags[i].equals(responseTags[i])) continue;
            ++this.mNumUnknownTokensCorrect;
        }
    }

    public double caseAccuracy() {
        return (double)this.mNumCasesCorrect / (double)this.mNumCases;
    }

    public Set<String> knownTokenSet() {
        return Collections.unmodifiableSet(this.mKnownTokenSet);
    }

    public void addKnownToken(String token) {
        this.mKnownTokenSet.add(token);
    }

    public double unknownTokenAccuracy() {
        return (double)this.mNumUnknownTokensCorrect / (double)this.mNumUnknownTokens;
    }

    @Deprecated
    public void addLatticeCase(String[] tokens, String[] referenceTags, TagWordLattice lattice) {
        HmmEvaluation.verifyEqualLengths("tokens", "referenceTags", tokens, referenceTags);
        HmmEvaluation.verifyEqual(tokens, lattice.tokens());
        for (int i = 0; i < tokens.length; ++i) {
            List<ScoredObject<String>> scoredTags = lattice.log2ConditionalTagList(i);
            double[] log2JointProbs = new double[scoredTags.size()];
            String[] responseNBestTags = new String[scoredTags.size()];
            for (int j = 0; j < scoredTags.size(); ++j) {
                log2JointProbs[j] = scoredTags.get(j).score();
                responseNBestTags[j] = scoredTags.get(j).getObject().toString();
            }
            JointClassification jc = new JointClassification(responseNBestTags, log2JointProbs);
            this.mLatticeEvaluation.addClassification(referenceTags[i], jc);
        }
    }

    public void addNBestCase(String[] tokens, String[] referenceTags, Iterator<ScoredObject<String[]>> nBestIterator) {
        HmmEvaluation.verifyEqualLengths("tokens", "referenceTags", tokens, referenceTags);
        for (int i = 0; i < this.mMaxNBest && nBestIterator.hasNext(); ++i) {
            ScoredObject<String[]> response = nBestIterator.next();
            Object[] responseTags = response.getObject();
            if (!Arrays.equals(referenceTags, responseTags)) continue;
            this.mNBestHistogram.increment(i);
            this.mLastNBest = i;
            return;
        }
        this.mLastNBest = this.mMaxNBest;
        this.mNBestHistogram.increment(this.mMaxNBest);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        sb.append("#Cases=" + this.mNumCases);
        sb.append("\n  #Toks=" + this.mNumTokens);
        sb.append("\n  Tok Acc=");
        formatter.format("%5.3f", this.mFirstBestEvaluation.confusionMatrix().totalAccuracy());
        sb.append("\n  Case Acc=");
        formatter.format("%5.3f", this.caseAccuracy());
        sb.append("\n  Lattice Acc=");
        formatter.format("%5.3f", this.mLatticeEvaluation.confusionMatrix().totalAccuracy());
        sb.append("\n  Unknown Toks=" + this.mNumUnknownTokens);
        sb.append("\n  Unknown Tok Acc=");
        formatter.format("%5.3f", this.unknownTokenAccuracy());
        return sb.toString();
    }

    int lastNBest() {
        return this.mLastNBest;
    }

    static void verifyEqualLengths(String name1, String name2, String[] xs1, String[] xs2) {
        if (xs1.length == xs2.length) {
            return;
        }
        String msg = "Arrays " + name1 + " and " + name2 + " must be same length." + " Found " + name1 + ".length=" + xs1.length + " " + name2 + ".length=" + xs2.length;
        throw new IllegalArgumentException(msg);
    }

    static void verifyEqual(String[] tokens1, String[] tokens2) {
        if (tokens1.length != tokens2.length) {
            String msg = "Tokens must match lattice tokens. tokens.length=" + tokens1.length + " lattice.tokens().length=" + tokens2.length;
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < tokens1.length; ++i) {
            if (tokens1[i].equals(tokens2[i])) continue;
            String msg = "Tokens must match lattice tokens. tokens[" + i + "]=" + tokens1[i] + " != lattice.tokens()[" + i + "]=" + tokens2[i];
            throw new IllegalArgumentException(msg);
        }
    }
}

