/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.Utility;

public class Binomials {
    private static int absoluteMax = 15;
    int max;
    int[][] binomial;
    boolean noDiscontinuous;

    public Binomials(int max) {
        this(max, false);
    }

    public Binomials(int max, boolean noDiscontinuous) {
        this.noDiscontinuous = noDiscontinuous;
        if (max > absoluteMax) {
            max = absoluteMax;
        }
        this.max = max;
        this.initBinomial();
    }

    private void initBinomial() {
        this.binomial = new int[this.max + 1][this.max + 1];
        Utility.fillDoubleIntArray(this.binomial, -1);
        if (this.noDiscontinuous) {
            int c = 0;
            while (c <= this.max) {
                int n = 0;
                while (n <= c) {
                    this.binomial[c][n] = Utility.binomial(c, n);
                    ++n;
                }
                ++c;
            }
        } else {
            int c = 0;
            while (c <= this.max) {
                int n = 0;
                while (n <= c) {
                    this.binomial[c][n] = Utility.binomial_continuous(c, n);
                    ++n;
                }
                ++c;
            }
        }
    }

    public int get(int c, int n) {
        return this.binomial[c][n];
    }

    public static void main(String[] args) {
        Binomials B = new Binomials(10);
        int c = 0;
        while (c <= 10) {
            int n = 0;
            while (n <= c) {
                System.out.print(String.valueOf(B.binomial[c][n]) + "\t");
                ++n;
            }
            System.out.println();
            ++c;
        }
    }
}

