/*
 * Decompiled with CFR 0.152.
 */
package wordModel;

public class WordFeatures {
    boolean isNumber;
    boolean containsDigit;
    boolean containsDot;
    boolean containsHiphen;
    boolean containsApostrophe;
    boolean containsDollar;
    boolean multiWords;
    boolean capitalized;
    public static String isNumberMatch = "[\\d\\.,\\\\/]+";
    public static String containsDigitMatch = ".*\\d.*";

    public WordFeatures(String word) {
        if (WordFeatures.isNumber(word)) {
            this.isNumber = true;
            return;
        }
        this.containsDigit = WordFeatures.containsDigit(word);
        this.containsDot = WordFeatures.containsDot(word);
        this.containsHiphen = WordFeatures.containsHiphen(word);
        this.multiWords = WordFeatures.isMultiWords(word);
        this.capitalized = WordFeatures.isCapitalized(word);
        this.containsApostrophe = WordFeatures.containsApostrophe(word);
        this.containsDollar = WordFeatures.containsDollar(word);
    }

    public String toFeatureVector() {
        return String.valueOf(this.containsDollar ? "1" : "0") + (this.containsApostrophe ? "1" : "0") + (this.capitalized ? "1" : "0") + (this.multiWords ? "1" : "0") + (this.containsHiphen ? "1" : "0") + (this.containsDot ? "1" : "0") + (this.containsDigit ? "1" : "0") + (this.isNumber ? "1" : "0");
    }

    public static boolean isNumber(String word) {
        return word.matches(isNumberMatch);
    }

    public static boolean containsDigit(String word) {
        return word.matches(containsDigitMatch);
    }

    public static boolean containsDot(String word) {
        return word.indexOf(46) >= 0;
    }

    public static boolean containsHiphen(String word) {
        return word.indexOf(45) > 0;
    }

    public static boolean isMultiWords(String word) {
        return word.indexOf(32) >= 0;
    }

    public static boolean isCapitalized(String word) {
        return !Character.isLowerCase(word.charAt(0));
    }

    public static boolean containsApostrophe(String word) {
        return word.indexOf(39) >= 0;
    }

    public static boolean containsDollar(String word) {
        return word.indexOf(36) >= 0;
    }

    public static void main(String[] args) {
    }
}

