import os
import codecs
import pandas as pd

root = os.path.join(".", "Results_OpenLID")

for file in os.listdir(root):
    if file.endswith(".txt"):
    
        meta = file.split(".")
        region = meta[2]
        model = meta[3]
        print(region, model, file)
        results = []
        p = []
        r = []
        f1 = []
        s = 0
        
        with codecs.open(os.path.join(root, file), "r", encoding = "utf-8") as f:
        
            for line in f:
                line = line.strip().split()
                
                if len(line) == 5:
                    if line[4] != "0":
                        results.append(line)
                        p.append(eval(line[1]))
                        r.append(eval(line[2]))
                        f1.append(eval(line[3]))
                        s += eval(line[4])
                        
        p = sum(p)/len(p)
        r = sum(r)/len(r)
        f1 = sum(f1)/len(f1)
        results.append(["Macro_Avg", p, r, f1, s])
                        
        df = pd.DataFrame(results, columns = ["Language", "Precision", "Recall", "F-Score", "Support"])
        
        print(df)