# Efficient Active Learning with Adapters

This repository contains code implementation for the paper *Efficient Active Learning with Adapters*.

### Contributions of this paper include:

- Using adapters in active learning **does not harm the performance**
- Adapters can be used in classification tasks in **various domains** (news, finance and muiti-domain have been tested)
- Acquisition model with an adapter **performs better than a distilled model of a different architecture**, thus alleviating the acquisition-successor mismatch problem
- Total time of AL loop can be **decreased by 27.15%** on average.

## Structure 
- The figures with learning curves can be accessed from the `plots` directory.

- The `notebooks` directory offers quick scripts for runtime calculation. Refer to REDAME.md in the directory.

- The `uncertainty_transformers` directory contains scripts for calculating and comparing the uncertainty scores of different models. Refer to README.md in the directory.

The code is based on the [ALToolbox](https://github.com/AIRI-Institute/al_toolbox/tree/main), a framework for active learning.

## Reproducubility

#### Dependencies 
The dependencies can be installed via `python poetry`:
- run `poetry init` to initialize the project
- run `poetry install` to intstall the dependencies. This will automatically resolve and install the dependencies from the `poetry.lock` and `poetry.toml` files.

#### Experiments
The `configs` directory contains a general `config.yaml` file with experiments for all model configurations tested in this research. To run the experiments for a particular dataset, specify the name of the corresponding `al_cls_{dataset_name}.yaml` config in `tasks.config_name`.

#### Hardware
All experiments were run on **NVIDIA GeForce RTX 3090 24GB**.




