import openai
openai.base_url = 'https://service-5qepn3zi-1258569187.sg.tencentapigw.com/release/v1/'
openai.timeout = 6000
with open('api_xinwu.key') as f:
    openai.api_key = f.read().strip()

import backoff
import abc
import warnings
import time
import traceback
best_of = 1
max_tokens = 256


# @cache.cache
# @backoff.on_exception(backoff.expo, Exception, max_tries=10)
def codex_helper(extended_prompt, model):
    assert 1 <= best_of <= 20
    if model in ("gpt-4-0125-preview", "gpt-3.5-turbo-0301", "gpt-3.5-turbo"):
        # print(extended_prompt)
        responses = openai.chat.completions.create(
                model=model,
                messages=extended_prompt['messages'],
                temperature=extended_prompt.get('temperature', 0),
                max_tokens=extended_prompt.get('max_tokens', max_tokens),
                top_p = 1,
                frequency_penalty=0,
                presence_penalty=0,
                # stop=["\n\n"],
                )
        # print(responses)
 
    return responses.choices[0].message.content



class CodexModel():
    name = 'codex'
    requires_gpu = False
    max_batch_size = 5

    # Not batched, but every call will probably be a batch (coming from the same process)

    def __init__(self, model = "gpt-3.5-turbo-0301"):
        if model == 'gpt4':
            self.model = 'gpt-4-0125-preview'
        elif model == 'chatgpt':
            self.model = 'gpt-3.5-turbo-0301'
        else:
            self.model = model
        print(self.model)


    def forward(self, extended_prompt=None):

        result = self.forward_(extended_prompt)

        return result

    def forward_(self, extended_prompt, retry=0):
        if retry >= 2:
            return None
        if len(extended_prompt) > self.max_batch_size:
            response = []
            for i in range(0, len(extended_prompt), self.max_batch_size):
                response += self.forward_(extended_prompt[i:i + self.max_batch_size])
        try:
            response = codex_helper(extended_prompt, self.model)
            retry += 1
        except Exception as e:
            # Some other error like an internal OpenAI error
            print('test')
            time.sleep(30)
            print("Retrying Codex")
            print(e)
            print(traceback.format_exc())
            print(extended_prompt['messages'][0]['content'])
            print(extended_prompt['messages'][1]['content'])
            response = self.forward_({'messages': [{"role": "system", "content": extended_prompt['messages'][0]['content']},
                    {"role": "user", "content": extended_prompt['messages'][1]['content']+'\nshort answer'}]}, retry)
        return response
