#!/bin/bash
set -x
conda activate deepspeed
BASEDIR=$(pwd)
WS=$BASEDIR

pretrain_model=<pretrain LLM dir>
model_dir=<LLM after finetuning dir>
testset=<testset dir>
evals=$WS/output/eval
mkdir -p $evals

if [ ! -s $model_dir/convert/pytorch_model.bin ];
then 
    mkdir -p $model_dir/convert
    python $WS/applications/DeepSpeed-Chat/training/step1_supervised_finetuning/evaluation_scripts/convert_lora_model.py \
    --model_path $model_dir/pytorch_model.bin --save_dir $model_dir/convert --lora_dim 8
    cp $model_dir/config.json $model_dir/convert/
fi 

export CUDA_VISIBLE_DEVICES=0
torchrun --nproc_per_node 1  --master_port 12345 \
    $WS/applications/DeepSpeed-Chat/training/step1_supervised_finetuning/prompt_eval_test.py \
    --deepspeed  --model_name_or_path_baseline  $pretrain_model \
    --model_name_or_path_finetune $model_dir/convert \
    --input $testset --language English --zero_stage 1 \
    --per_device_batch_size 1 \
    --max_new_tokens 256 \
    --output $evals/test.jsonl > $evals/test.txt   

