from rouge import Rouge
import json
from transformers.trainer_utils import EvalPrediction
import os

def compute_accuracy(eval_prediction: EvalPrediction, inputs, output_path: str = None):
    if output_path is not None:
        os.makedirs(os.path.split(output_path)[0], exist_ok=True)

    predictions: list[str] = eval_prediction.predictions
    labels: list[str] = eval_prediction.label_ids
    num_samples = len(predictions)

    pred_data = []
    count = 0
    for i in range(num_samples):
        output_text = predictions[i]
        label_text = labels[i]
        input_text = inputs[i]
        pred_data.append({"input": input_text, "pred": output_text, "label": label_text})
        if output_text == label_text:
            count += 1

    print('\nACCURACY: {}'.format(count / num_samples))
    eval_results = {'accuracy': count / num_samples}
    if output_path is not None:
        json.dump({"pred_results": pred_data, "eval_results": eval_results}, open(output_path, 'w', encoding='utf-8'),
                  ensure_ascii=False, indent=4)
    return eval_results
