/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.meteor.scorer;

import edu.cmu.meteor.util.Constants;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeteorConfiguration {
    private String language;
    private int langID;
    private String task;
    private int normalization;
    private ArrayList<Double> parameters;
    private ArrayList<Integer> modules;
    private ArrayList<Double> moduleWeights;
    private int beamSize;
    private URL wordFileURL;
    private URL synDirURL;
    private URL paraDirURL;
    private boolean charBased;

    public MeteorConfiguration() {
        this.setDefaults();
    }

    private void setDefaults() {
        this.setLanguage("english");
        this.setTask("default");
        this.setBeamSize(40);
        this.setWordFileURL(Constants.getDefaultWordFileURL(this.langID));
        this.setSynDirURL(Constants.DEFAULT_SYN_DIR_URL);
        this.setParaFileURL(Constants.getDefaultParaFileURL(this.langID));
        this.setNormalization(0);
        this.setCharBased(false);
    }

    public String getConfigID() {
        return "meteor-1.5-" + (this.charBased ? "ch-" : "wo-") + Constants.getLanguageShortName(this.langID) + "-" + Constants.getNormName(this.normalization) + "-" + Constants.getWeightListString(this.parameters) + "-" + Constants.getModuleListString(this.modules) + "-" + Constants.getWeightListString(this.moduleWeights);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = Constants.normLanguageName(string);
        this.langID = Constants.getLanguageID(this.language);
        this.setParaFileURL(Constants.getDefaultParaFileURL(this.langID));
        int n = Constants.getDefaultTask(this.langID);
        this.setTask(n);
    }

    public int getLangID() {
        return this.langID;
    }

    public String getTask() {
        return this.task;
    }

    public String getTaskDesc() {
        return Constants.getTaskDescription(this.task);
    }

    public void setTask(String string) {
        this.setTask(Constants.getTaskID(string));
    }

    public void setTask(int n) {
        this.setParameters(Constants.getParameters(this.langID, n));
        this.setModules(Constants.getModules(this.langID, n));
        ArrayList<Double> arrayList = Constants.getModuleWeights(this.langID, n);
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        for (int i = 0; i < this.modules.size(); ++i) {
            arrayList2.add(arrayList.get(i));
        }
        this.setModuleWeights(arrayList2);
        this.setTaskName(Constants.getTaskName(n));
        this.setCharBased(n == 3);
    }

    private void setTaskName(String string) {
        this.task = string;
    }

    public int getNormalization() {
        return this.normalization;
    }

    public void setNormalization(int n) {
        this.normalization = n;
    }

    public ArrayList<Double> getParameters() {
        return new ArrayList<Double>(this.parameters);
    }

    public String getParametersString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Double d : this.parameters) {
            stringBuilder.append(d + " ");
        }
        return stringBuilder.toString().trim();
    }

    public void setParameters(ArrayList<Double> arrayList) {
        this.setTaskName("custom");
        this.parameters = new ArrayList<Double>(arrayList);
    }

    public void setParameters(String string, String string2) {
        this.setTaskName(string2);
        this.parameters = Constants.getParameters(Constants.getLanguageID(Constants.normLanguageName(string)), Constants.getTaskID(string2));
    }

    public ArrayList<Integer> getModules() {
        return new ArrayList<Integer>(this.modules);
    }

    public String getModulesString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer n : this.modules) {
            stringBuilder.append(Constants.getModuleName(n) + " ");
        }
        return stringBuilder.toString().trim();
    }

    public void setModules(ArrayList<Integer> arrayList) {
        this.setTaskName("custom");
        this.modules = new ArrayList();
        for (Integer n : arrayList) {
            this.modules.add(n);
        }
    }

    public void setModulesByName(ArrayList<String> arrayList) {
        this.setTaskName("custom");
        this.modules = new ArrayList();
        for (String string : arrayList) {
            this.modules.add(Constants.getModuleID(string));
        }
    }

    public ArrayList<Double> getModuleWeights() {
        return new ArrayList<Double>(this.moduleWeights);
    }

    public String getModuleWeightsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Double d : this.moduleWeights) {
            stringBuilder.append(d + " ");
        }
        return stringBuilder.toString().trim();
    }

    public void setModuleWeights(ArrayList<Double> arrayList) {
        this.setTaskName("custom");
        this.moduleWeights = new ArrayList<Double>(arrayList);
    }

    public URL getWordFileURL() {
        return this.wordFileURL;
    }

    public void setWordFileURL(URL uRL) {
        try {
            this.wordFileURL = new URL(uRL.toString());
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Error: Word list directory URL NOT set");
            malformedURLException.printStackTrace();
        }
    }

    public URL getSynDirURL() {
        return this.synDirURL;
    }

    public void setSynDirURL(URL uRL) {
        try {
            this.synDirURL = new URL(uRL.toString());
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Error: Synonym directory URL NOT set");
            malformedURLException.printStackTrace();
        }
    }

    public URL getParaDirURL() {
        return this.paraDirURL;
    }

    public void setParaFileURL(URL uRL) {
        try {
            this.paraDirURL = new URL(uRL.toString());
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Error: Synonym directory URL NOT set");
            malformedURLException.printStackTrace();
        }
    }

    public int getBeamSize() {
        return this.beamSize;
    }

    public void setBeamSize(int n) {
        this.beamSize = n;
    }

    public boolean getCharBased() {
        return this.charBased;
    }

    public void setCharBased(boolean bl) {
        this.charBased = bl;
    }

    public void newLang(String string) {
        this.setLanguage("other");
        this.setTask("universal");
        try {
            this.setWordFileURL(new File(string, "function.words").toURI().toURL());
            this.setParaFileURL(new File(string, "paraphrase.gz").toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Error: files NOT set");
            malformedURLException.printStackTrace();
        }
        this.setNormalization(1);
    }

    public MeteorConfiguration(Properties properties) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string;
        String string2;
        this.setDefaults();
        String string3 = properties.getProperty("language");
        if (string3 != null) {
            this.setLanguage(string3);
        }
        if ((string2 = properties.getProperty("task")) != null) {
            this.setTask(string2);
        }
        if ((string = properties.getProperty("parameters")) != null) {
            object6 = new ArrayList();
            object5 = new StringTokenizer(string);
            while (((StringTokenizer)object5).hasMoreTokens()) {
                ((ArrayList)object6).add(Double.parseDouble(((StringTokenizer)object5).nextToken()));
            }
            this.setParameters((ArrayList<Double>)object6);
        }
        if ((object6 = properties.getProperty("moduleWeights")) != null) {
            object5 = new ArrayList();
            object4 = new StringTokenizer((String)object6);
            while (((StringTokenizer)object4).hasMoreTokens()) {
                ((ArrayList)object5).add(Double.parseDouble(((StringTokenizer)object4).nextToken()));
            }
            this.setModuleWeights((ArrayList<Double>)object5);
        }
        if ((object5 = properties.getProperty("modules")) != null) {
            object4 = new ArrayList();
            object3 = new StringTokenizer((String)object5);
            while (((StringTokenizer)object3).hasMoreTokens()) {
                ((ArrayList)object4).add(((StringTokenizer)object3).nextToken());
            }
            this.setModulesByName((ArrayList<String>)object4);
            object2 = this.getModuleWeights();
            object = new ArrayList();
            for (int i = 0; i < ((ArrayList)object4).size(); ++i) {
                if (i < ((ArrayList)object2).size()) {
                    ((ArrayList)object).add(((ArrayList)object2).get(i));
                    continue;
                }
                ((ArrayList)object).add(0.0);
            }
            this.setModuleWeights((ArrayList<Double>)object);
        }
        if ((object4 = properties.getProperty("beamSize")) != null) {
            this.setBeamSize(Integer.parseInt((String)object4));
        }
        if ((object3 = properties.getProperty("wordFile")) != null) {
            try {
                this.setWordFileURL(new File((String)object3).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Error: Word list directory URL NOT set");
                malformedURLException.printStackTrace();
            }
        }
        if ((object2 = properties.getProperty("synDir")) != null) {
            try {
                this.setSynDirURL(new File((String)object2).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Error: Synonym directory URL NOT set");
                malformedURLException.printStackTrace();
            }
        }
        if ((object = properties.getProperty("paraFile")) != null) {
            try {
                this.setParaFileURL(new File((String)object).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Error: Paraphrase directory URL NOT set");
                malformedURLException.printStackTrace();
            }
        }
        Boolean bl = Boolean.parseBoolean(properties.getProperty("norm"));
        Boolean bl2 = Boolean.parseBoolean(properties.getProperty("lower"));
        Boolean bl3 = Boolean.parseBoolean(properties.getProperty("noPunct"));
        Boolean bl4 = Boolean.parseBoolean(properties.getProperty("nBest"));
        if (bl4.booleanValue()) {
            this.setNormalization(0);
        } else if (bl.booleanValue()) {
            if (bl3.booleanValue()) {
                this.setNormalization(3);
            } else {
                this.setNormalization(2);
            }
        } else if (bl2.booleanValue()) {
            this.setNormalization(1);
        } else {
            this.setNormalization(0);
        }
        Boolean bl5 = Boolean.parseBoolean(properties.getProperty("charBased"));
        this.setCharBased(bl5);
        Boolean bl6 = Boolean.parseBoolean(properties.getProperty("newLang"));
        if (bl6.booleanValue()) {
            this.newLang(properties.getProperty("filesDir"));
        }
    }
}

