/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import java.util.ArrayList;

public abstract class RecursiveTreeTransformer
implements TreeTransformer {
    @Override
    public Tree transformTree(Tree tree) {
        return this.transformHelper(tree);
    }

    public Tree transformHelper(Tree tree) {
        if (tree.isLeaf()) {
            return this.transformTerminal(tree);
        }
        return this.transformNonterminal(tree);
    }

    public Tree transformTerminal(Tree tree) {
        return tree.treeFactory().newLeaf(this.transformTerminalLabel(tree));
    }

    public Tree transformNonterminal(Tree tree) {
        ArrayList<Tree> children = new ArrayList<Tree>(tree.children().length);
        for (Tree child : tree.children()) {
            children.add(this.transformHelper(child));
        }
        return tree.treeFactory().newTreeNode(this.transformNonterminalLabel(tree), children);
    }

    public Label transformTerminalLabel(Tree tree) {
        return this.transformLabel(tree);
    }

    public Label transformNonterminalLabel(Tree tree) {
        return this.transformLabel(tree);
    }

    public Label transformLabel(Tree tree) {
        if (tree.label() == null) {
            return null;
        }
        return tree.label().labelFactory().newLabel(tree.label());
    }
}

