/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.gui;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.ConstituentFactory;
import edu.stanford.nlp.trees.LabeledConstituent;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;

public class Tdiff {
    private static final ConstituentFactory cf = LabeledConstituent.factory();

    private Tdiff() {
    }

    public static Set<Constituent> markDiff(Tree t1, Tree t2) {
        Set<Constituent> t1Labels;
        Set<Constituent> set = t1Labels = t1 == null ? Generics.newHashSet() : t1.constituents(cf);
        if (t2 != null) {
            t2.setSpans();
            for (Tree subTree : t2) {
                if (!subTree.isPhrasal()) continue;
                IntPair span = subTree.getSpan();
                Constituent c = cf.newConstituent(span.getSource(), span.getTarget(), subTree.label(), 0.0);
                if (t1Labels.contains(c)) {
                    t1Labels.remove(c);
                    ((CoreLabel)subTree.label()).set(CoreAnnotations.DoAnnotation.class, false);
                    continue;
                }
                ((CoreLabel)subTree.label()).set(CoreAnnotations.DoAnnotation.class, true);
            }
        }
        return t1Labels;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java Tdiff tree1 tree2");
            return;
        }
        File tree1Path = new File(args[0]);
        File tree2Path = new File(args[1]);
        try {
            LabeledScoredTreeReaderFactory trf = new LabeledScoredTreeReaderFactory();
            TreeReader tR1 = trf.newTreeReader(new BufferedReader(new FileReader(tree1Path)));
            TreeReader tR2 = trf.newTreeReader(new BufferedReader(new FileReader(tree2Path)));
            Tree t1 = tR1.readTree();
            Tree t2 = tR2.readTree();
            Set<Constituent> t1Diff = Tdiff.markDiff(t1, t2);
            System.out.println(t2.pennString());
            System.out.println();
            for (Constituent c : t1Diff) {
                System.out.println(c);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found!");
        }
        catch (IOException e) {
            System.err.println("Unable to read file!");
        }
    }
}

