/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.CorefCluster;
import edu.stanford.nlp.dcoref.CorefScorer;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.util.Generics;
import java.util.Map;
import java.util.Set;

public class ScorerMUC
extends CorefScorer {
    public ScorerMUC() {
        super(CorefScorer.ScoreType.MUC);
    }

    @Override
    protected void calculateRecall(Document doc) {
        int rDen = 0;
        int rNum = 0;
        Map<Integer, Mention> predictedMentions = doc.allPredictedMentions;
        for (CorefCluster g : doc.goldCorefClusters.values()) {
            if (g.corefMentions.size() == 0) {
                SieveCoreferenceSystem.logger.warning("NO MENTIONS for cluster " + g.getClusterID());
                continue;
            }
            rDen += g.corefMentions.size() - 1;
            rNum += g.corefMentions.size();
            Set<CorefCluster> partitions = Generics.newHashSet();
            for (Mention goldMention : g.corefMentions) {
                if (!predictedMentions.containsKey(goldMention.mentionID)) {
                    --rNum;
                    continue;
                }
                partitions.add(doc.corefClusters.get(predictedMentions.get((Object)Integer.valueOf((int)goldMention.mentionID)).corefClusterID));
            }
            rNum -= partitions.size();
        }
        if (rDen != doc.allGoldMentions.size() - doc.goldCorefClusters.values().size()) {
            System.err.println("rDen is " + rDen);
            System.err.println("doc.allGoldMentions.size() is " + doc.allGoldMentions.size());
            System.err.println("doc.goldCorefClusters.values().size() is " + doc.goldCorefClusters.values().size());
        }
        assert (rDen == doc.allGoldMentions.size() - doc.goldCorefClusters.values().size());
        this.recallNumSum += (double)rNum;
        this.recallDenSum += (double)rDen;
    }

    @Override
    protected void calculatePrecision(Document doc) {
        int pDen = 0;
        int pNum = 0;
        Map<Integer, Mention> goldMentions = doc.allGoldMentions;
        for (CorefCluster c : doc.corefClusters.values()) {
            if (c.corefMentions.size() == 0) continue;
            pDen += c.corefMentions.size() - 1;
            pNum += c.corefMentions.size();
            Set<CorefCluster> partitions = Generics.newHashSet();
            for (Mention predictedMention : c.corefMentions) {
                if (!goldMentions.containsKey(predictedMention.mentionID)) {
                    --pNum;
                    continue;
                }
                partitions.add(doc.goldCorefClusters.get(goldMentions.get((Object)Integer.valueOf((int)predictedMention.mentionID)).goldCorefClusterID));
            }
            pNum -= partitions.size();
        }
        assert (pDen == doc.allPredictedMentions.size() - doc.corefClusters.values().size());
        this.precisionDenSum += (double)pDen;
        this.precisionNumSum += (double)pNum;
    }
}

