from transformers import CLIPProcessor, CLIPModel
import argparse
import json


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--clip_model', type=str)
    parser.add_argument('--prompt_json', type=str)
    parser.add_argument('--output_path', type=str)
    args = parser.parse_args()

    model = CLIPModel.from_pretrained(args.clip_model)
    processor = CLIPProcessor.from_pretrained(args.clip_model)

    with open(args.prompt_json,'r',encoding='utf-8') as f:
        prompts = json.load(f)

    token_list= []
    for prompt in prompts:
        token_list.append(processor([prompt], return_tensors='pt')['input_ids'].squeeze().tolist())
    with open(args.output_path,'w',encoding='utf-8') as f:
        json.dump(token_list, f)
