# CO-STORM

## Setup

1. conda environment

   ```shell
   conda create -n co-storm python=3.11
   conda activate co-storm
   pip install -r requirements.txt
   ```

2. under project root, prepare `secrets.toml`

   ```shell
   # Set up OpenAI API key.
   OPENAI_API_KEY="your_openai_api_key"
   # If you are using the API service provided by OpenAI, include the following line:
   OPENAI_API_TYPE="openai"
   # If you are using the API service provided by Microsoft Azure, include the following lines:
   OPENAI_API_TYPE="azure"
   AZURE_API_BASE="your_azure_api_base_url"
   AZURE_API_VERSION="your_azure_api_version"
   # Set up You.com search API key.
   YDC_API_KEY="your_youcom_api_key"
   ```

## Run experiments & code

1. Bash scripts

   ```shell
   # To run Co-STORM
   ./baseline/run_new_method.bash
   
   # To run Co-STORM ablations
   ./baseline/run_new_method_no_moderator.bash
   ./baseline/run_new_method_no_multi_experts.bash
   
   # To run baseline methods
   ./baseline/run_baseline_direct_chat.bash
   ./baseline/run_baseline_storm_qa.bash
   ```

2. `./src/runner.py` provides a minimal working example as playground. 

