export CUDA_VISIBLE_DEVICES=0

# Make sure your environment has enough GPUs for the model
base_save_dir="results_ft"

# Often, the experiment name will be the same as the model name. It can be different for transfer attacks.
method_name="EnsembleGCG"
experiment_name="llama2_7b" 
model_name="llama2_7b"

behaviors_path="./data/behavior_datasets/harmbench_behaviors_text_test.csv"
max_new_tokens=512
incremental_update="False"

for k in inter_new_l20
do
    for mode in dev test
    do

    id="standard_${k}_${mode}"
    experiment_dir="$base_save_dir/$method_name/$experiment_name"
    test_cases_path="$experiment_dir/test_cases/ood_cases_${id}.json"
    save_path="$experiment_dir/completions/${model_name}_${id}.json"

    ./scripts/generate_completions.sh $model_name $behaviors_path $test_cases_path $save_path $max_new_tokens $incremental_update
    done
done
