import pickle
import os, sys
import filenames
import argparse

from beir.retrieval.search.lexical import BM25Search as BM25
from beir.retrieval.evaluation import EvaluateRetrieval


def main(training_query_path, corpus_path, save_path):
    with open(training_query_path, 'rb') as f:
        training_queries = pickle.load(f)

    with open(corpus_path, 'rb') as f:
        corpus = pickle.load(f)

    #### Provide parameters for elastic-search
    hostname = "localhost" 
    index_name = "csfcube" 
    initialize = True

    model = BM25(index_name=index_name, hostname=hostname, initialize=initialize)
    retriever = EvaluateRetrieval(model, k_values=[1,3,5,10,100,500])
    training_BM25_results = retriever.retrieve(corpus, training_queries)

    with open(save_path, 'wb') as f:
        pickle.dump(training_BM25_results, f)   

if __name__ == '__main__':
    
    parser = argparse.ArgumentParser()
    parser.add_argument('--training_query_path', default='./Dataset/CSFCube/Promptgator_training_queries', type=str)
    parser.add_argument('--corpus_path', default='./Dataset/CSFCube/corpus', type=str)
    parser.add_argument('--save_path', default='./Outputs/CSFCube_training_BM25_results', type=str)

    args = parser.parse_args()

    main(args.training_query_path, args.corpus_path, args.save_path)