import matplotlib.pyplot as plt
import numpy as np
import seaborn as sns
# from matplotlib.colors import LinearSegmentedColormap
from matplotlib.colors import LinearSegmentedColormap, Normalize

depth =  [  0,  5, 11, 16, 21, 26, 32, 37, 42, 47, 53, 58, 63, 68, 74, 79, 84, 89,95,100]

with open('needle_results_mistral.txt', 'r') as reader:
    lines = reader.readlines()

data = []
length = []
for pos, each_line in enumerate(lines):
    if "context_length = " in each_line:
        length.append(int(each_line.split()[-1]))
        data_step = []
        for i in range(20):
            data_step.append(float(lines[pos + 3 + i].split()[0]))
        data.append(data_step)




# print(data)
# # 生成示例数据
data = np.array(data)

# 定义莫兰迪色系的自定义调色板
# blue_colors = [
#     '#e0f7fa',  # 浅蓝色
#     '#b2ebf2',  # 天蓝色
#     '#80deea',  # 浅青色
#     '#4dd0e1',  # 亮青色
#     '#26c6da',  # 中青色
#     '#00acc1',  # 深青色
#     '#00838f',  # 深蓝色
#     '#005662'   # 深靛色
# ]

# # 创建自定义的蓝色色系colormap
# blue_cmap = LinearSegmentedColormap.from_list("blue", blue_colors)

blue_colors = [
    '#e0f7fa',  # 浅蓝色
    '#b2ebf2',  # 天蓝色
    '#80deea',  # 浅青色
    '#4dd0e1',  # 亮青色
    '#26c6da',  # 中青色
    '#00acc1',  # 深青色
    '#00838f',  # 深蓝色
    '#005662'   # 深靛色
]

# 创建自定义的蓝色色系colormap
blue_cmap = LinearSegmentedColormap.from_list("blue", blue_colors)

# 调整色彩渐变，使过渡更柔和
blue_cmap = sns.blend_palette(blue_colors, as_cmap=True)


# 精确控制横轴和纵轴的坐标位置（可选）
# ax.set_xticks(np.arange(len(x_labels)) + 0.5)
# ax.set_yticks(np.arange(len(y_labels)) + 0.5)

# # 设置横轴和纵轴的标签
# ax.set_xticklabels(x_labels, rotation=45, ha="right")
# ax.set_yticklabels(y_labels, rotation=0)
# 画热度图
plt.figure(figsize=(8, 4))
sns.heatmap(data, cmap=blue_cmap, xticklabels=depth, yticklabels=length)
# plt.title('Morandi Color Scheme Heatmap')

# 保存热度图到文件
plt.savefig('morandi_heatmap.png', dpi=300, bbox_inches='tight')

# 显示热度图
plt.show()