#!/usr/bin/env bash

set -x
set -e

DIR="$( cd "$( dirname "$0" )" && cd .. && pwd )"
echo "working directory: ${DIR}"

if [ -z "$OUTPUT_DIR" ]; then
  OUTPUT_DIR="${DIR}/checkpoint/kd_$(date +%F-%H%M.%S)"
fi

TRAIN_FILE=$1
VALIDATION_FILE=$2
MODEL_NAME_OR_PATH=$3

mkdir -p "${OUTPUT_DIR}"

PROC_PER_NODE=$(nvidia-smi --list-gpus | wc -l)
deepspeed src/train_biencoder.py --deepspeed ds_config.json \
    --model_name_or_path  simlm-base-msmarco \
    --per_device_train_batch_size 64 \
    --per_device_eval_batch_size 64 \
    --kd_mask_hn False \
    --kd_cont_loss_weight 0.2 \
    --seed 123 \
    --do_train \
    --do_kd_biencoder \
    --t 0.02 \
    --fp16 \
    --train_file "$TRAIN_FILE" \
    --validation_file "$VALIDATION_FILE" \
    --q_max_len 32 \
    --p_max_len 144 \
    --do_multi_kd \
    --train_n_passages 35 \
    --dataloader_num_workers 1 \
    --learning_rate 3e-5 \
    --max_steps 20000 \
    --warmup_steps 0 \
    --share_encoder True \
    --logging_steps 500 \
    --output_dir "${OUTPUT_DIR}" \
    --data_dir "${DATA_DIR}" \
    --save_total_limit 10 \
    --save_strategy steps \
    --save_steps 2000 \
    --evaluation_strategy steps \
    --eval_steps 7000 \
    --load_best_model_at_end \
    --metric_for_best_model mrr \
    --greater_is_better True \
    --remove_unused_columns False \
    --overwrite_output_dir \
    --disable_tqdm False \
    --report_to none "$@"
