TRANSFORMATION_CLASS_NAMES = {
    "shuffle": "transformations.Argot_transformation.ChineseShuffleCharacterSwap",
    "split": "transformations.Argot_transformation.ChineseSplittingCharacterSwap",
    "synonym": "",
    'same_pinyin': "transformations.Argot_transformation.ChineseHomophoneCharacterSwap",
    "sim_pinyin": "transformations.Argot_transformation.ChineseSimilarPinyinCharacterSwap",
    "glyph": "transformations.Argot_transformation.ChineseGlyphCharacterSwap",
    "Argot": "transformations.Argot_transformation."
}

SEARCH_CLASS_NAMES = {
    "greedy-word-wir": "textattack.search_method.GreedyWordSwapWIR",
    "pso": "textattack.search_method.ParticleSwarmOptimization",
    "ga": "textattack.search_method.AlzantotGeneticAlgorithm",
    "iga": "textattack.search_method.ImprovedGeneticAlgorithm",

}

ARGS_SPLIT_TOKEN = "^"


def create_transformation_from_args(args):
    transformation_name = args.transformation

    if ARGS_SPLIT_TOKEN in transformation_name:
        transformation_name, params = transformation_name.split(ARGS_SPLIT_TOKEN)

        if transformation_name in TRANSFORMATION_CLASS_NAMES:
            transformation = eval(
                f"{TRANSFORMATION_CLASS_NAMES[transformation_name]}({params})"
            )
        else:
            raise ValueError(
                f"Error: unsupported transformation {transformation_name}"
            )
    else:
        if transformation_name in TRANSFORMATION_CLASS_NAMES:
            transformation = eval(
                f"{TRANSFORMATION_CLASS_NAMES[transformation_name]}()"
            )
        else:
            raise ValueError(
                f"Error: unsupported transformation {transformation_name}"
            )

    return transformation


def create_search_method_from_args(args):
    search_method_name = args.search_method

    if ARGS_SPLIT_TOKEN in search_method_name:
        search_method_name, params = search_method_name.split(ARGS_SPLIT_TOKEN)

        if search_method_name in SEARCH_CLASS_NAMES:
            search_method = eval(
                f"{SEARCH_CLASS_NAMES[search_method_name]}({params})"
            )
        else:
            raise ValueError(
                f"Error: unsupported search method {search_method_name}"
            )
    else:
        if search_method_name in SEARCH_CLASS_NAMES:
            search_method = eval(
                f"{SEARCH_CLASS_NAMES[search_method_name]}()"
            )
        else:
            raise ValueError(
                f"Error: unsupported search method {search_method_name}"
            )

    return search_method
