theory question_36_2

imports Main

consts
  Antigens :: "entity ⇒ bool"
  CancerCells :: "entity ⇒ bool"
  TransplantedOrgans :: "entity ⇒ bool"
  Proteins :: "entity ⇒ bool"
  Surface :: "property ⇒ bool"
  ImmuneSystem :: "entity ⇒ bool"
  HasProperty :: "entity ⇒ entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ property ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

axiomatization where
  explanation_1: "∀a c to p s is. Antigens a ∧ CancerCells c ∧ TransplantedOrgans to ∧ Proteins p ∧ Surface s ∧ ImmuneSystem is 
  	→ (∃e. HasProperty a p ∧ On a c s ∧ On a to s ∧ Agent e is ∧ Patient e a)"

theorem hypothesis:
  assumes asm: "Antigens a ∧ CancerCells c ∧ TransplantedOrgans k"
  (* Hypothesis: Antigens (a) are found on cancer cells (c) and the cells of transplanted kidneys (k). *)
  shows "∃a c k. Antigens a ∧ CancerCells c ∧ TransplantedOrgans k ∧ HasProperty a  the_entity 'Proteins'  ∧ On a c  the_entity 'Surface'  ∧ On a k  the_entity 'Surface' "
proof -
  from asm have "Antigens a" and "CancerCells c" and "TransplantedOrgans k" by simp_all
  then have "HasProperty a (the_entity 'Proteins')" using explanation_1 by blast
  moreover
  have "On a c (the_entity 'Surface')" and "On a k (the_entity 'Surface')" using explanation_1 by blast+
  ultimately show ?thesis by blast
qed

end
