theory question_61_2
imports Main

begin

typedecl entity
typedecl event

consts
  EatingSeafood :: "entity ⇒ bool"
  Eating :: "entity ⇒ bool"
  Woman :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation 1: ∀x. EatingSeafood(x) ⟶ Eating(x) *)
axiomatization where
  explanation_1: "∀x. EatingSeafood x ∧ Eating x"

theorem hypothesis:
  (* Premise: ∀x. EatingSeafood(x) ⟶ Eating(x) *)
  assumes asm: "EatingSeafood x ∧ Eating x"
  (* Hypothesis: ∃x e. Woman(x) ∧ Eating(e) ∧ Agent(e, x) *)
  shows "∃x e. Woman x ∧ EatingSeafood e ∧ Agent  EatingSeafood e  x"
proof -
  from asm have "∀x. EatingSeafood x ⟶ Eating x" by fact
  then have "EatingSeafood x ⟶ Eating x" by simp
  from asm have "EatingSeafood x" by simp
  then have "Eating x" by blast
  then have "∃e. Eating e ∧ Agent Eating e x" by (rule exI[where x="Eating x"])
  then have "∃e. EatingSeafood e ∧ Agent EatingSeafood e x" by (rule exI[where x="EatingSeafood x"], fact)
  then have "∃x e. Woman x ∧ EatingSeafood e ∧ Agent EatingSeafood e x" by (rule exI[where x="Woman x"], fact)
qed

end
