theory question_27_1
imports Main
begin
typedecl entity
typedecl event

consts
  Person :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Old :: "entity ⇒ bool"
  HardwareParts :: "entity ⇒ bool"
  Dirty :: "entity ⇒ bool"
  Sells :: "event ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: If a person is on a sidewalk, they are outside because sidewalks are found outdoors. *)
axiomatization where
  explanation_1: "∀x y. Person x ∧ Sidewalk y ∧ On x y ⟶ Outside x"

theorem hypothesis:
  (* Premise: An old man sells hardware parts on a dirty sidewalk. *)
  assumes asm: "Man x ∧ Old x ∧ HardwareParts y ∧ Sidewalk z ∧ Dirty z ∧ Sells e y ∧ Agent e x ∧ Patient e y ∧ On x z"
  (* Hypothesis: The man is outside. *)
  shows "∃x. Man x ∧ Outside x"
proof -
  from asm have "Man x ∧ Sidewalk z ∧ On x z" by blast
  then have "Man x ∧ Outside x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
