theory question_63_0

imports Main

begin

typedecl entity
consts
  Ohio :: "entity ⇒ bool"
  WasOnceCoveredByWater :: "event ⇒ entity ⇒ bool"
  Covered :: "event ⇒ entity ⇒ bool"
  ExtinctSeaAnimal :: "entity ⇒ bool"
  Trilobite :: "entity ⇒ bool"
  Fossils :: "entity ⇒ bool"
  Found :: "event ⇒ entity ⇒ entity ⇒ bool"
  Past :: "event ⇒ bool"

(* Explanation: If an entity was once covered by water, then it was covered. *)
axiomatization where
  explanation: "∀x e. WasOnceCoveredByWater e x ⟶ Covered e x"

theorem hypothesis:
  (* Premise: Exist(e3, f) ∧ ExtinctSeaAnimal(t) ∧ Trilobite(t) ∧ Fossils(f) ∧ Found(e3, f, t) ∧ Ohio(o) ⟶ Covered(e4, o) ∧ Past(e4) *)
  assumes asm: "Exist e3 f ∧ ExtinctSeaAnimal t ∧ Trilobite t ∧ Fossils f ∧ Found e3 f t ∧ Ohio o ∧ Covered e4 o ∧ Past e4"
  (* Hypothesis: Ohio(x) ∧ WasOnceCoveredByWater(e, x) ⟶ Covered(e, x) *)
  shows "Ohio x ∧ WasOnceCoveredByWater e x ∧ Covered e x"
proof -
  from asm have "Fossils f ∧ Found e3 f t ∧ Trilobite t ∧ ExtinctSeaAnimal t" by simp
  then have "WasOnceCoveredByWater e t" using explanation by blast
  then have "Ohio x ∧ WasOnceCoveredByWater e x ∧ Covered e x" using asm `t` by blast
qed

end
