theory question_88_7
imports Main

begin

typedecl entity
typedecl event

consts
  Gymnast :: "entity ⇒ bool"
  Skill :: "entity ⇒ bool"
  Displaying :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Specific_to_gymnasts :: "entity ⇒ bool"
  Flip :: "event ⇒ bool"
  Blue_flooring :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation: If a gymnast performs a flip, then they are displaying something. *)
axiomatization where
  explanation_1: "∀x e. Gymnast x ∧ Flip e ∧ Agent e x ⟶ Displaying e"

(* Explanation: Displaying something with a flip is a kind of displaying skills. *)
axiomatization where
  explanation_2: "∀e. Displaying e ∧ Flip e ⟶ (∃y. Skill y ∧ Patient e y)"

(* Explanation: If a gymnast is displaying skills, then they are displaying something specific to gymnasts. *)
axiomatization where
  explanation_3: "∀x e. Gymnast x ∧ Displaying e ∧ Agent e x ⟶ Specific_to_gymnasts (∃y. Skill y ∧ Patient e y)"

theorem hypothesis:
  (* Premise: A gymnast does a flip on blue flooring. *)
  assumes asm: "Gymnast x ∧ Flip e ∧ Agent e x ∧ Blue_flooring e"
  (* Hypothesis: There is a gymnast who performs a flip and in doing so, displays something. *)
  shows "∃x e. Gymnast x ∧ Flip e ∧ Agent e x ∧ Displaying e"
proof -
  from asm have "Gymnast x ∧ Flip e ∧ Agent e x" by blast
  then have "Displaying e" using explanation_1 by blast
  then show "∃x e. Gymnast x ∧ Flip e ∧ Agent e x ∧ Displaying e" by blast
qed

end
