theory question_51_7
imports Main

begin

typedecl entity
typedecl event

consts
  Giving :: "entity ⇒ event ⇒ bool"
  Speaking :: "entity ⇒ event ⇒ bool"
  Man :: "entity ⇒ bool"
  PublicSpeaking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation 1: If someone gives a speech, then they are speaking at an event. *)
axiomatization where
  explanation_1: "∀x e1 e2. Giving x e1 ⟶ Speaking x e2"

theorem hypothesis:
  (* Premise: ∀x::entity. None(x) *)
  assumes asm: "None x"
  (* Hypothesis: ∃x e. Man(x) ∧ PublicSpeaking(e) ∧ Agent(e, x) *)
  shows "∃x e. Man x ∧ PublicSpeaking e ∧ Agent e x"
proof -
  from asm have "None (Agent e x)" for x e :: entity event by simp
  then have "~ (Giving x e)" for x e :: entity event by (rule gives_implies_speaking[THEN iffD1])
  then have "Speaking x e1" for x e1 :: entity event by (rule explanation_1[THEN iffD1])
  then have "∃e. PublicSpeaking e ∧ Agent e x" by (rule public_speaking_from_speaking)
  then show ?thesis by (rule_tac x="x" in ex_intro)
qed

end
